package com.yyjz.icop.orgcenter.orgsystem.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.orgsystem.vo.OrgSystemItemVO;

/**
 * 组织体系记录服务
 * 
 * @author GavinWood
 */
public interface OrgSystemItemService extends BaseOrgSystemService<OrgSystemItemVO>{
	
	/**
	 * 获取指定组织体系的根节点
	 * @param orgSysId
	 * @return 根节点，或null（根节点不存在）
	 * @throws BusinessException
	 */
	List<OrgSystemItemVO> getRoots(String orgSysId, String tenantId) throws BusinessException;
	
	/**
	 * 获取直接子节点
	 * @param sysId
	 * @param pid
	 * @return
	 * @throws BusinessException
	 */
	List<OrgSystemItemVO> getDirectChildren(String sysId, String pid) throws BusinessException;
	
	/**
	 * 分页
	 * @param keyword
	 * @param pageable
	 * @param tenantId
	 * @param categoryId
	 * @return 实体：{@link OrgSystemItemVO}
	 * @throws BusinessException
	 */
	Page<OrgSystemItemVO> page(String keyword, Pageable pageable, String tenantId, String sysId, String condition) throws BusinessException;
	
	/**
	 * 获取指定节点下直接下级的最大innercode
	 * @param sysId
	 * @param pid
	 * @param tenantId
	 * @return
	 * @throws BusinessException
	 */
	int getMaxInnercode(String sysId, String pid, String tenantId) throws BusinessException;
	
	/**
	 * 获取最大order（租户隔离，组织体系隔离）
	 * @param sysId
	 * @param pid
	 * @param tenantId
	 * @return
	 * @throws BusinessException
	 */
	public int getMaxOrder(String sysId, String tenantId) throws BusinessException;
	
	/**
	 * 根据组织体系获取体系下节点列表
	 * @param sysId 指定的组织体系
	 * @param status
	 * @return 实体：{@link<OrgSystemItemVO>}
	 * @throws BusinessException
	 */
	List<OrgSystemItemVO> list(String sysId, List<Integer> status, String tenantId) throws BusinessException;
	
	/**
	 * 根据组织体系获取体系下节点列表
	 * @param sysId 指定的组织体系
	 * @param searchText 关键字
	 * @param status
	 * @return 实体：{@link<OrgSystemItemVO>}
	 * @throws BusinessException
	 */
	List<OrgSystemItemVO> list(String sysId, String searchText, List<Integer> status, String tenantId) throws BusinessException;
	
	/**
	 * 根据组织体系获取体系下节点（“名称，编码”）列表
	 * @param sysId 指定的组织体系
	 * @param status
	 * @return 实体：{@link<OrgSystemItemVO>}
	 * @throws BusinessException
	 */
	List<String> listSysNameAndCode(String sysId, List<Integer> status, String tenantId) throws BusinessException;
	
	/**
	 * 删除本下
	 * @param id 指定节点主键
	 * @return 实体：{@link<OrgSystemItemVO>}
	 * @throws BusinessException
	 */
	boolean delChildren(String id) throws BusinessException;
}
