package com.yyjz.icop.orgcenter.orgsystem.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.orgsystem.vo.OrgSystemVO;

/**
 * 组织体系服务
 * 
 * @author GavinWood
 */
public interface OrgSystemService extends BaseOrgSystemService<OrgSystemVO>{
	/**
	 * 分页
	 * @param keyword
	 * @param pageable
	 * @param tenantId
	 * @param categoryId
	 * @return 实体：{@link V}
	 * @throws BusinessException
	 */
	Page<OrgSystemVO> page(String keyword, Pageable pageable, String tenantId, String categoryId, String condition) throws BusinessException;
	
	/**
	 * 根据分类获取组织体系列表
	 * @param categoryId 组织体系分类
	 * @param status
	 * @return 实体：{@link<OrgSystemVO>}
	 * @throws BusinessException
	 */
	List<OrgSystemVO> list(String categoryId, List<Integer> status, String tenantId) throws BusinessException;
}
