package com.yyjz.icop.orgcenter.orgsystem.vo;

import org.apache.commons.lang3.StringUtils;

/**
 * 组织体系节点记录
 * 
 * @author GavinWood
 */
public class OrgSystemItemVO extends BaseOrgSystemVO{
	private static final long serialVersionUID = 8844257594069301776L;
	
	/**
	 * 组织体系记录来源组织(不能作为外键joinbd_company表，只作为一种溯源字段)，虚节点关联ID = SYSTEM_ITEM
	 */
	protected String orgUnitId;
	
	/**
	 * 组织体系记录所属组织体系ID( 关联 bd_org_system表 )
	 */
	protected String sysId;
	
	/**
	 * 组织体系编码( 冗余bd_org_system.system_code )
	 */
	protected String sysCode;
	
	/**
	 * 组织体系名称( 冗余bd_org_system.system_name )
	 */
	protected String sysName;
	
	/**
	 * 组织体系记录所属版本ID( 关联 bd_org_system_version表 )
	 */
	protected String sysVarId;
	
	/**
	 * 组织体系记录编码(初始化 = bd_company.company_code )
	 */
	protected String sysItemCode;
	
	/**
	 * 组织体系记录名称(初始化 = bd_company.company_name )
	 */
	protected String sysItemName;
	
	/**
	 * 组织体系记录简称(初始化 = bd_company.company_sh_name)
	 */
	protected String sysItemShName;
	
	/**
	 * 组织体系记录上级 默认值 = ""
	 */
	protected String sysItemPid;
	
	/**
	 * 组织体系记录上级名称 默认值 = ""
	 */
	protected String sysItemPname;
	
	/**
	 * 组织体系记录树内部码 四位代表一个层级 内部码0001代表根 组织内码按照版本进行隔离(即不同版本根均从0001开始，最大250层)
	 */
	protected String innercode;
	
	private boolean isLeaf = false;
	
	public String getOrgUnitId(){
		return orgUnitId;
	}

	public void setOrgUnitId(String orgUnitId){
		this.orgUnitId = orgUnitId;
	}

	public String getSysId(){
		return sysId;
	}

	public void setSysId(String sysId){
		this.sysId = sysId;
	}

	public String getSysCode(){
		return sysCode;
	}

	public void setSysCode(String sysCode){
		this.sysCode = sysCode;
	}

	public String getSysName(){
		return sysName;
	}

	public void setSysName(String sysName){
		this.sysName = sysName;
	}

	public String getSysVarId(){
		return sysVarId;
	}

	public void setSysVarId(String sysVarId){
		this.sysVarId = sysVarId;
	}

	public String getSysItemCode(){
		return sysItemCode;
	}

	public void setSysItemCode(String sysItemCode){
		this.sysItemCode = sysItemCode;
	}

	public String getSysItemName(){
		return sysItemName;
	}

	public void setSysItemName(String sysItemName){
		this.sysItemName = sysItemName;
	}

	public String getSysItemShName(){
		return sysItemShName;
	}

	public void setSysItemShName(String sysItemShName){
		this.sysItemShName = sysItemShName;
	}

	public String getSysItemPid(){
		return sysItemPid;
	}

	public void setSysItemPid(String sysItemPid){
		this.sysItemPid = sysItemPid;
	}

	public String getSysItemPname(){
		return sysItemPname;
	}

	public void setSysItemPname(String sysItemPname){
		this.sysItemPname = sysItemPname;
	}

	public String getInnercode(){
		return innercode;
	}

	public void setInnercode(String innercode){
		this.innercode = innercode;
	}

	public boolean getIsLeaf(){
		return isLeaf;
	}

	public void setIsLeaf(boolean isLeaf){
		this.isLeaf = isLeaf;
	}
	
	public String insertSql(){
		StringBuffer sql = new StringBuffer();
		sql.append("(" 
				+ "'" + getId() + "'," 
				+ "'" + getOrgUnitId() + "'," 
				+ "'" + getSysId() + "'," 
				+ "'" + getSysCode() + "'," 
				+ "'" + getSysName() + "'," 
				+ ((null == getSysVarId()) ? null : ("'" + getSysVarId() + "'")) + "," 
				+ "'" + getSysItemCode() + "'," 
				+ "'" + getSysItemName() + "',"
				+ ((null == getSysItemShName()) ? null : ("'" + getSysItemShName() + "'")) + ","
				+ "'" + getSysItemPid() + "'," 
				+ "'" + getSysItemPname() + "'," 
				+ "'" + getInnercode() + "'," 
				+ getEnabled() + ","
				+ getOrderNum() + "," 
				+ "'" + getCreationBy() + "'," 
				+ "'" + getCreationTimestamp() + "'," 
				+ "'" + getModifiedBy() + "',"
				+ "'" + getModificationTimestamp() + "'," 
				+ "'" + getTenantId() + "'," 
				+ getDr() + ","
				+ ((null == getRemark()) ? null : ("'" + getRemark() + "'"))
				+ ") ");

		return sql.toString();
				
	}
}
