package com.yyjz.icop.orgcenter.position.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.orgcenter.position.vo.PositionVO;
import com.yyjz.icop.orgcenter.positiondictionary.vo.PositionDictionaryVO;

/**
 * <p>
 * 本类主要功能：岗位提供的接口
 * <p>
 * 
 * @version YYCC_V1.0
 * @author yujian1
 * @time 2016年5月24日 下午2:43:42
 */
public interface IPositionService {
	/**
	 * 
	 * 方法功能描述：返回岗位总数 <b>参数说明</b>
	 * 
	 * @param orgId
	 * @return
	 *         <p>
	 * @author yujian1
	 * @time 2016年5月24日 下午3:15:53
	 */
	public long count(String orgId);

	/**
	 * 
	 * 方法功能描述：搜索所有岗位 <b>参数说明</b>
	 * 
	 * @param param
	 * @param orgId
	 * @param pageRequest
	 * @return
	 *         <p>
	 * @author yujian1
	 * @time 2016年5月24日 下午3:16:10
	 */
	public List<PositionVO> searchPosition(String param, String orgId, PageRequest pageRequest);

	/**
	 * 
	 * 方法功能描述：删除 <b>参数说明</b>
	 * 
	 * @param id
	 *            <p>
	 * @author yujian1
	 * @time 2016年5月24日 下午5:41:07
	 */
	void deleteOne(String id);

	/**
	 * 
	 * 方法功能描述：批量删除 <b>参数说明</b>
	 * 
	 * @param idList
	 *            <p>
	 * @author yujian1
	 * @time 2016年5月24日 下午5:41:17
	 */
	void deleteBatch(List<String> idList);

	/**
	 * 
	 * 保存岗位信息。
	 * <p>
	 * <b>examples:</b>
	 * <p>
	 * 使用示例
	 * <p>
	 * <b>参数说明</b>
	 * 
	 * @param vo
	 * @return
	 *         <p>
	 * @author shl
	 * @time 2016年8月7日 下午3:09:15
	 */
	public PositionVO savePosition(PositionVO vo);

	/**
	 * 
	 * 方法功能描述：批量保存岗位 <b>参数说明</b>
	 * 
	 * @param dictionaryVOList
	 * @param deptId
	 *            <p>
	 * 
	 * @author yujian1
	 * @time 2016年5月25日 上午11:29:27
	 */
	public List<PositionVO> saveBatch(List<PositionDictionaryVO> dictionaryVOList, String deptId);

	/**
	 * 按照条件搜索岗位
	 */
	public Page<PositionVO> searchPositonByCondition(Map<String, Object> searchParams, PageRequest pageRequest);

	void editPosition(PositionVO vo);

	public PositionVO findOneById(String id);

	/**
	 * 参照查询结果
	 * 
	 * @param searchText
	 * @param relyCondition
	 * @param pageRequest
	 * @return
	 */
	public List<PositionVO> refSearchPosition(String searchText, String relyCondition, PageRequest pageRequest);

	/**
	 * 获取参照总条数
	 * 
	 * @param searchText
	 * @param relyCondition
	 * @return
	 */
	public long refCount(String searchText, String relyCondition);

	/**
	 * @param dictionaryId
	 * @return 根据岗位字典的id 获取 所有的岗位信息
	 */
	public List<PositionVO> getPositionsByPositionDictionaryId(String dictionaryId);

	/**
	 * @param deptId
	 * @return 获取该部门下对应的岗位 对应的岗位字典的 id
	 */
	List<String> findPositionDicIdsByDeptId(String deptId);

	/**
	 * @param dictionaryIds
	 * @return 批量 对应的岗位字典的 id
	 */
	List<PositionVO> getPositionsByPositionDictionaryIds(List<String> dictionaryIds);

	public PositionVO getPositionById(String positionId);

	public List<PositionVO> getPostionsByIds(List<String> ids);

	public long countParam(String deptId, String param);

	public Page<PositionVO> refSearchPosition(Pageable pageable, String companyId, String searchText);
	Page<PositionVO> refSearchPosition(Pageable pageable, String companyId, String searchText,int enabled);

	String editPostOrder(String id, Integer type);

	/**
	 * @desc 根据公司及岗位字典ids查询岗位ids
	 * @param companyId
	 * @param ids
	 * @return
	 */
	public List<String> findByCompanyIdAndDictIds(String companyId, List<String> ids);

    public Integer countPositionByPositionDictionaryIds(List<String> idList);

    Boolean deletePositionById(String id);

	/**
	 * 根据部门ID获取岗位信息
	 * @param deptId
	 * @return
	 */
	public List<PositionVO> getPostionsByDeptId(String deptId);

		/**
		 * 根据公司ID删除该公司所有岗位
		 * @param id
		 */
	void delAllPositionByCompanyId(String id);

	/**
	 * 根据用户ID查询该用户所关联的人员，然后根据人员ID得到主职、兼职人员的岗位IDS: posIds
	 * @param userId
	 * 				登录用户ID
	 * @return
	 */
    List<String> queryPositionIdsByUserId(String userId);
 
    /**
     * hr同步_根据sourceId查询岗位信息
     */
    public PositionVO getPositionBySourceidForHrsync(String deptId,String sourceId);

	/**
	 * 级联保存岗位信息(同时根据名称查询岗位字典是否存在，不存在则创建岗位字典和岗位字典等级)
	 * @param PositionVO 岗位信息
	 * @return
	 */
	PositionVO saveCascad(PositionVO vo) throws Exception;
}

