/**
 * $文件说明$
 *
 * @author Alex
 * @version 
 * @see
 * @since
 * @time 2016年4月28日 下午11:58:53
 */
package com.yyjz.icop.orgcenter.positiondictionary.service;

import java.util.List;

import org.springframework.data.domain.PageRequest;

import com.yyjz.icop.orgcenter.positiondictionary.vo.PositionDictionaryVO;

/**
 * <p>
 * 本类主要功能：岗位字典接口
 * <p>
 * @version ARCH_V1.0
 * @author yujian1
 * @time 2016年4月28日 下午11:58:53
 */
public interface IPositionDictionaryService {
	/*
	* 根据层级IDs获取岗位字典的数量
	* ***/
	Integer countPositionDictionaryByLevelIds(List<String> idList);

	/**
	 * 
	 * 方法功能描述：新增修改岗位字典
	 * <b>参数说明</b>
	 * @param entity
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:02:02
	 */
	public PositionDictionaryVO save(PositionDictionaryVO vo);
	/**
	 * 
	 * 方法功能描述：删除岗位字典
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:02:22
	 */
	public void deleteOne(String id);
	/**
	 * 
	 * 方法功能描述：批量删除
	 * <b>参数说明</b>
	 * @param idList
	 * <p>
	 * @author yujian1
	 * @time 2016年5月12日 下午2:42:54
	 */
	public String deleteBatch(List<String> idList);
	/**
	 * 
	 * 方法功能描述：通过主键查询岗位字典
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:02:50
	 */
	public PositionDictionaryVO queryPosition(String id);

	/**
	 * 
	 * 方法功能描述：返回岗位总数
	 * <b>参数说明</b>
	 * @param levelId
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年5月12日 上午11:26:17
	 */
	public long count(String levelId, List<String> existPositionDicIds);
	
	/**
	 * 
	 * 方法功能描述：搜索所有岗位
	 * <b>参数说明</b>
	 * @param param
	 * @param levelId
	 * @param pageRequest
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年5月12日 上午11:18:36
	 */
	public List<PositionDictionaryVO> searchPosition(String param, String levelId, List<String> existPositionDicIds, PageRequest pageRequest);
	
	/**
	 * 
	 * 方法功能描述：搜索所有岗位-需求修改，增加“分类名称”字段
	 * <b>参数说明</b>
	 * @param param
	 * @param levelId
	 * @param pageRequest
	 * @return
	 * <p>
	 * @author 
	 * @time 2017年11月02日
	 */
	public List<PositionDictionaryVO> searchPositionNew(String param, String levelId, List<Integer> positionTypes, PageRequest pageRequest);
	
	/**
	 * 
	 * 方法功能描述：通过主键List查询岗位字典s
	 * <b>参数说明</b>
	 * @param idList
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:02:50
	 */
	public List<PositionDictionaryVO> queryPositions(List<String> idList);
	
	
	/**
	 * @param roleId
	 * @return
	 * 根据角色id  获取 对应的岗位字典的信息
	 */
	public List<PositionDictionaryVO> findAllPositionDictionarysByPosDicIds(List<String> ids);
	/**
	 * 根据Id及code查询是否有值
	 * @param vo
	 * @return
	 */
	public Boolean findPositionDictionaryByIdAndCode(PositionDictionaryVO vo);
	/**
	 * 
	 * 方法功能描述：返回搜索岗位总数
	 * <b>参数说明</b>
	 * @param levelId
	 * @return
	 * <p>
	 * @time 2016年5月12日 上午11:26:17
	 */
	public long countText(String levelId, List<String> existPositionDicIds, List<Integer> positionTypes, String param);
	public PositionDictionaryVO findPositionDictionaryByCode(PositionDictionaryVO vo) ;

	List<PositionDictionaryVO> search(String word);
	
	//上下移动岗位分类
    public String editPositionOrder(String id,Integer type);

    public Boolean deletePositionDictionaryById(String id);

	/**
	 * 根据岗位字典Ids批量查询岗位字典信息
	 * 
	 * @param posDicIds
	 * @param searchText 
	 * @param startIndex
	 * @param pageSize
	 * @return
	 */
	List<PositionDictionaryVO> findAllPositionDictsByPosDicIds(List<String> posDicIds, String searchText, int startIndex, int pageSize);

	Long queryAllRolePositionCount(List<String> posDicIds, String searchText);

	/**
	 * 根据登录用户ID：userId 查询主职、兼职的岗位的岗位字典IDS：posDicIds
	 * @param userId
	 * 				登录用户ID
	 * @return
	 */
	List<String> queryAllPositionDicIdsByUserId(String userId);
}
