/**
 * $文件说明$
 *
 * @author Alex
 * @version 
 * @see
 * @since
 * @time 2016年4月28日 下午11:58:53
 */
package com.yyjz.icop.orgcenter.positiondictionary.service;

import java.util.List;

import com.yyjz.icop.orgcenter.positiondictionary.vo.PositionLevelVO;

/**
 * 
 * <p>
 * 本类主要功能：岗位层级接口
 * <p>
 * @version YYCC_V1.0
 * @author yujian1
 * @time 2016年5月10日 下午5:32:15
 */
public interface IPositionLevelService {

	public String getMaxInnercodeByLen(int codeLen);

	/**
	 * 
	 * 方法功能描述：新增岗位层级
	 * <b>参数说明</b>
	 * @param entity
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:02:02
	 */
	public void addPositionLevel(PositionLevelVO entity);

	/**
	 * 
	 * 方法功能描述：通过主键查询岗位层级
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:02:50
	 */
	public PositionLevelVO queryPositionLevel(String id);

	/**
	 * 
	 * 方法功能描述：查询所有的岗位层级
	 * <b>参数说明</b>
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:03:07
	 */
	public List<PositionLevelVO> getAllPositionLevels();

	/**
	 * 
	 * 方法功能描述：查询获取最大的仅下级节点的innercode的后四位，为新增时拼接innercode做准备
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:03:29
	 */
	public String getMaxInnercode(String id);

	/**
	 * 
	 * 方法功能描述：查询父级节点的innercode，为新增时拼接innercode做准备
	 * <b>参数说明</b>
	 * @param id
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年4月29日 上午00:04:01
	 */
	public String getParentInnercode(String id);

	public List<PositionLevelVO> getLevelsByName(String name);

	public String deleteBatch(List<String> positionIds);

	public String getRootId();

	/**
	 * 
	 * 方法功能描述：查询根节点
	 * <b>参数说明</b>
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年11月10日 上午11:24:33
	 */
	public List<PositionLevelVO> queryRootPositionLevel();

	/**
	 * 
	 * 方法功能描述：根据innercode查询下一级孩子
	 * <b>参数说明</b>
	 * @param innercode
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年11月10日 上午11:27:14
	 */
	public List<PositionLevelVO> queryChildPositionLevel(String innercode);

	/**
	 * 
	 * 方法功能描述：根据ID查询其及其下面所有叶子
	 * <b>参数说明</b>
	 * @param ID
	 * @return
	 * <p>
	 * @author yujian1
	 * @time 2016年11月10日 上午11:27:14
	 */
	public List<PositionLevelVO> queryChildPositionLevelById(String Id);

	public List<PositionLevelVO> getByNameAndLevel(String levelName, Integer innerCodeLen,Integer parentInnerCodeLen, String parentInnerCode);

	public PositionLevelVO findLastLevelByNames(String names,String split);

    public PositionLevelVO getPositionLevelByLevelId(String levelId);

    public void updatePositionLevel(PositionLevelVO vo);
    
    //上下移动岗位字典分类
    public String editPositionLevelOrder(String id,Integer type);

    public String getMaxInnerCode();

	List<PositionLevelVO> getByNameAndLevel(String levelName,
			Integer innerCodeLen);
	int countLevelsByPid(List<String> levelIds);
}
