package com.yyjz.icop.orgcenter.projectdept.service;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.projectdept.vo.ProjectDeptVO;

/**
 * @Description 项目部模板Service接口
 * @Author GavinWood
 * @Version 1.0
 * @CreateTime 2018年07月23日 14:56:02
 */
public interface IProjectDeptQryService{

	public ProjectDeptVO getById(String id, String tenantId) throws BusinessException;

	public ProjectDeptVO getByIdAndDr(String id, int dr, String tenantId) throws BusinessException;

	public ProjectDeptVO getBySourceId(String sourceId, String tenantId) throws BusinessException;

	public ProjectDeptVO getByCode(String code, String tenantId) throws BusinessException;

	public List<ProjectDeptVO> listByName(String name, String tenantId) throws BusinessException;

	public List<ProjectDeptVO> listByStatus(List<Integer> statusList, String tenantId) throws BusinessException;

	public List<ProjectDeptVO> listByStatusAndDr(List<Integer> statusList, int dr, String tenantId)
			throws BusinessException;

	public Page<ProjectDeptVO> page(String pid, Pageable pageable, String searchText, int direction,
			List<Integer> enabledStatus, String tenantId) throws BusinessException;

	public List<ProjectDeptVO> listByIds(List<String> ids, List<Integer> statusList, String tenantId)
			throws BusinessException;

	public List<ProjectDeptVO> listByIdsAndDr(List<String> ids, List<Integer> statusList, int dr, String tenantId)
			throws BusinessException;

	public List<ProjectDeptVO> listByCodeOrNameLike(String keyword, List<Integer> statusList, String tenantId)
			throws BusinessException;

	public ProjectDeptVO getByOrgUnit(String id, String tenantId) throws BusinessException;

	public ProjectDeptVO getParentByOrgUnit(String id, String tenantId) throws BusinessException;
}
