package com.yyjz.icop.orgcenter.projectdept.service;

import java.util.List;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.projectdept.vo.ProjectDeptVO;

/**
 * @Description 项目部模板Service接口
 * @Author GavinWood
 * @Version 1.0
 * @CreateTime 2018年07月23日 14:56:02
 */
public interface IProjectDeptService{
	public ProjectDeptVO save(ProjectDeptVO vo) throws BusinessException;

	public List<ProjectDeptVO> save(List<ProjectDeptVO> vos) throws BusinessException;

	public ProjectDeptVO update(ProjectDeptVO vo) throws BusinessException;

	public List<ProjectDeptVO> update(List<ProjectDeptVO> vos) throws BusinessException;

	public boolean enable(ProjectDeptVO vo) throws BusinessException;
	
	public boolean enable(List<ProjectDeptVO> vos) throws BusinessException;

	public boolean enableWithNoCheck(List<ProjectDeptVO> vos) throws BusinessException;

	public boolean disable(ProjectDeptVO vo) throws BusinessException;
	
	public boolean move(ProjectDeptVO source, ProjectDeptVO target) throws BusinessException;

	public boolean disable(List<ProjectDeptVO> vo) throws BusinessException;

	public ProjectDeptVO remove(ProjectDeptVO vo) throws BusinessException;

	public List<ProjectDeptVO> removeBatch(List<ProjectDeptVO> vos) throws BusinessException;
}
