package com.yyjz.icop.orgcenter.staff.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.orgcenter.staff.vo.BdStaffVO;
import com.yyjz.icop.orgcenter.staff.vo.OrgStaffRefVO;
import com.yyjz.icop.orgcenter.staff.vo.Pair;
import com.yyjz.icop.orgcenter.staff.vo.ProjectDeptAuthStaffVO;
import com.yyjz.icop.orgcenter.staff.vo.StaffPartJobVO;
import com.yyjz.icop.orgcenter.staff.vo.StaffTypeVO;
import com.yyjz.icop.orgcenter.staff.vo.StaffUnionVO;
import com.yyjz.icop.orgcenter.staff.vo.StaffUserVO;
import com.yyjz.icop.orgcenter.staff.vo.StaffVO;
import com.yyjz.icop.orgcenter.staff.vo.SupplierStaffVO;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

public interface StaffService{

	public List<StaffUserVO> findStaffUserByParam(String param, String companyId, int pageNo, int pageSize,
			List<String> userIds);

	public int findStaffUserCountByParam(String param, String companyId, List<String> userIds);

	/**
	 * 根据部门id集合查询人员id集合
	 * 
	 * @param deptIds
	 * @return
	 */
	public List<String> getStaffIdsByDeptIds(String[] deptIds);

	/**
	 * 根据人员Id查找人员信息
	 */
	public StaffVO findOne(String id);

	/**
	 * 根据人员Id查找人员
	 * 
	 * @param ids
	 * @return
	 */
	public List<StaffVO> findStaffs(List<String> ids);

	/**
	 * 删除人员,只做逻辑删除
	 * 
	 * @param id
	 */
	void deleteOne(String id);

	/**
	 * 批量删除，提供事务支持
	 * 
	 * @param id
	 */
	void deleteBatch(List<String> idList);

	/**
	 * 保存人员信息
	 * 
	 * @param staff
	 * @param saveMsg
	 *            人员保存产生的信息
	 * @return
	 */
	public StaffVO save(StaffVO staff, JSONObject saveMsg);

	/**
	 * 保存人员兼职信息
	 * 
	 * @param staff
	 * @return
	 */
	public StaffPartJobVO save(StaffPartJobVO staffPartJob);

	/**
	 * 获取人员职位信息列表
	 * @param staffId 人员主键
	 * @return List<{@link StaffPartJobVO}
	 */
	public List<StaffPartJobVO> findAllStaffPartJobVOsById(String staffId);

	/**
	 * @param staffId
	 * @return 根据staffId获取兼职表中该Id对应的最新的一条记录的值，
	 *         cur_state字段值为0，且职务类型为主旨（property字段为0）
	 */
	public StaffPartJobVO findOneStaffPartJobVOById(String staffId);

	/**
	 * 根据人员名搜索人员
	 * 
	 * @param name
	 *            人员名字
	 */
	public List<StaffVO> findByName(String name);

	/**
	 * 返回人员总数
	 * 
	 * @return
	 */
	public long count(String param, String orgId);

	List<StaffVO> searchStaff(String param, String deptId, PageRequest pageRequest);

	Page<StaffVO> searchStaffPage(String param, String deptId, PageRequest pageRequest);

	Page<StaffVO> pageStaffByCompanyIds(String param, final List<String> companyIds, PageRequest pageRequest);

	Page<StaffVO> pageStaffByDeptIds(String param, final List<String> deptIds, PageRequest pageRequest);

	/**
	 * 用于参照按条件查询用户
	 */
	public List<StaffVO> refSearchStaff(String param, String relyCondition, PageRequest pageRequest);

	public long refCount(String param, String relyCondition);

	/**
	 * 修改人员名字
	 * 
	 * @param staff
	 *            人员对象
	 * @param name
	 *            新修改的人员名字
	 * @return
	 */
	public StaffVO changeName(StaffVO staff, String name);

	/**
	 * 
	 * 方法功能描述：得到code的数量，判断code是否重复用 <b>参数说明</b>
	 * 
	 * @param code
	 * @return
	 *         <p>
	 * @author yujian1
	 * @time 2016年6月14日 下午2:57:46
	 */
	public int getCodeCount(String code);

	/**
	 * 根据人员id集合查找用户id集合
	 * 
	 * @param staffIds
	 * @return
	 */
	public List<String> getUserIdsByStaffIds(List<String> staffIds);

	/**
	 * 根据部门id集合查询用户id集合
	 * 
	 * @param deptIds
	 * @return
	 */
	public List<String> getUserIdsByDeptIds(String[] deptIds);

	/**
	 * 根据部门id集合查询用户id集合
	 * 
	 * @param positionIds
	 * @return
	 */
	public List<String> getUserIdsByPositionIds(String[] positionIds);

	/**
	 * 
	 * 方法功能描述：根据关联的用户id查询人员对象 <b>参数说明</b>
	 * 
	 * @param userId
	 * @return
	 *         <p>
	 * @author yujian1
	 * @time 2016年6月18日 下午3:38:11
	 */
	public StaffVO getStaffByUserId(String userId);

	public List<CompanyVO> getCompanysByUserId(String userId);

	public CompanyVO getCompanyByUserId(String userId);

	/**
	 * @param staffId
	 * @return 获取最近的之前的调动工作记录
	 */
	public StaffPartJobVO getPreMoveWorkLog(String staffId);

	/**
	 * @param staffId
	 * @return 获取最近的之前的简直工作记录
	 */
	public StaffPartJobVO getPrePartWorkLog(String staffId);

	public List<StaffVO> getStaffByTime(String ts, String start, String count);

	public int getPageCount(String ts, String count);

	public List<StaffVO> getStaffByDeptId(String deptId);

	public List<StaffVO> getStaffByPostionId(String positionId);

	public List<StaffVO> getStaffByUserListId(String userId);

	public List<StaffVO> getStaffByCompany(String companyId);

	public CompanyVO getCompanyByStaff(String id);

	public List<String> getUserIdByCompany(String companyId);

	public List<StaffVO> getStaffByCompanys(String[] companyIds);

	public List<String> getUserIdsRelationStaffs();

	int getCredentialCodeCount(String credentialCode);

	public List<ProjectDeptAuthStaffVO> getStaffByPositionId(String positionId, String deptId, String positionIdPre,
			String deptIdPre);

	/**
	 * 根据搜索参数param以及分页获取结果
	 * 
	 * @param vos
	 * @param param
	 * @param pageNumber
	 * @param pageSize
	 * @return
	 */
	public List<ProjectDeptAuthStaffVO> getProjectDeptAuthStaffVOsByParam(List<ProjectDeptAuthStaffVO> vos,
			String param, int pageNumber, int pageSize);

	public List<ProjectDeptAuthStaffVO> getStaffAndJobPartByPositionId(String positionId);

	void deletPersonPartJobOne(String staffId, String companyId, String deptId, String positionId, int property);

	public void movePersonToPrePosition(String staffId, String companyId, String deptId, String positionId,
			int property, String jobTime);

	/**
	 * 移动端专用 按照修改时间查询人员，不做租户隔离，根据传入的tenantId进行查询，如果tenantId不存在，则查询所有人员
	 * 
	 * @param ts
	 * @param start
	 * @param count
	 * @param tenantId
	 * @return
	 */
	List<StaffVO> getStaffByTime2(String ts, String start, String count, String tenantId);

	/**
	 * 移动端专用 按照修改时间查询人员，不做租户隔离，根据传入的tenantId进行查询，如果tenantId不存在，则查询所有人员
	 * 
	 * @param ts
	 * @param start
	 * @param count
	 * @param tenantId
	 * @return
	 */
	List<StaffVO> getStaffByTime2New(String ts, String start, String count, String tenantId);
	
	/**
	 * 根据最终修改时间获取人员列表
	 * @param ts: 时间戳
	 * @param pageIndex：开始页数
	 * @param pageSize：每页记录条数
	 * @param tenantId：租户 
	 * @param ignoreDr：是否忽略逻辑删除
	 * @return 列表{@link StaffVO}
	 * @throws BusinessException
	 */
	Page<StaffVO> getStaffsByTS(String ts, int pageIndex, int pageSize, String tenantId, boolean ignoreDr) throws BusinessException;

	List<StaffVO> getStaffByCompanyIdAndName(String companyId, String name);

	public List<StaffVO> getParentStaffsBystaffId(String staffId);

	public List<StaffVO> getNoPartStaff(String partCompanyId, String deptId, String param, String curCompanyId,
			int pageNumber, int pageSize);

	public long getNoPartStaffCount(String partCompanyId, String deptId, String curCompanyId, String searchText);

	void deleteStaffBatch(List<String> idList);

	public List<StaffVO> getStaffByName(String name);

	public List<StaffUnionVO> searchStaffPageByCompanyId(String param, String companyId);

	List<StaffUnionVO> searchStaffsByDeptId(String param, String deptId);

	List<StaffUnionVO> searchStaffsByCompanyId(String param, String companyId);

	public List<ProjectDeptAuthStaffVO> getStaffByDeptId(String deptId, String deptIdPre);

	public List<ProjectDeptAuthStaffVO> getStaffByCompanyId(String companyId);

	public List<ProjectDeptAuthStaffVO> getStaffAndJobPartByDeptId(String deptId);

	public List<ProjectDeptAuthStaffVO> getStaffAndJobPartByCompanyId(String companyId);

	public StaffPartJobVO getStaffPartById(String partId);

	public UserBaseVO findUserByStaff(StaffVO staff);

	public List<StaffVO> getStaffsByMobile(List<String> mobile);

	/**
	 * 贵阳院数据推送
	 * 
	 * @param staffParams
	 * @return
	 */
	public String pushGyyStaffData(List<StaffParam> staffParams);

	List<CompanyVO> getCompanysByCompanyId(String companyId);

	public String queryPositionDictionaryIds(String userId);

	public Integer getMobileCount(String mobile);

	public List<String> queryStaffByCompanyIds(List<String> companyIds);

	public List<String> queryStaffPartjobByCompanyIds(List<String> companyIds);

	public List<String> getUserIdsPartjobByDeptIds(String[] deptId);

	public List<StaffVO> searchStaffsByDeptIdAll(List<String> deptIds, List<String> userid, String searchText,
			int pageNew, int pageSize);

	public List<StaffVO> searchStaffsByCompanyIdAll(List<String> companyId, List<String> userid, String searchText,
			int pageNew, int pageSize);

	public List<StaffVO> searchStaffsByCompanyIdAll(String companyId, List<String> userid, String searchText,
			int pageNew, int pageSize);

	public int getCountByByCompanyIdAll(List<String> companyId, List<String> userid, String searchText);

	public int getCountByByCompanyIdAll(String deptId, List<String> userid, String searchText);

	public int getCountByDeptIdAll(List<String> deptIds, List<String> userid, String searchText);

	public List<CompanyVO> getPartCompanysByInnercodes(List<String> innercodes);

	public List<String> getPartCompanyInnercodes(String userId);

	/**
	 * 根据身份证号列表查询对对应的人员信息
	 * 
	 * @param identifyCards
	 *            身份证号列表
	 * @return
	 */
	public Map<String, StaffVO> getStaffMapByIdentifyCards(List<String> identifyCards);

	public String editPersonOrder(String id, Long type);

	public Long getMaxPersonOrderByDeptId(String deptId);

	/**
	 * 根据组织Id、搜索关键字 统计对应用户的总数量
	 * 
	 * @param companyId
	 * @param param
	 * @param iscontainBelow
	 * @return
	 */
	public int countUsersByProperties(String companyId, String param, String iscontainBelow);

	/**
	 * 据组织Id、搜索关键字 统计对应用户的ID以及用户对应组织名称
	 * 
	 * @param companyId
	 * @param param
	 * @param iscontainBelow
	 * @param startIndex
	 * @param pageSize
	 * @return
	 */
	public Map<String, String> getUserIdByProperties(String companyId, String param, String iscontainBelow,
			int startIndex, int pageSize);

	public void clearBindUserInfo(String userId);

	/**
	 *
	 * @param userId
	 * @param roleId
	 * @return
	 */
	List<CompanyVO> getCompaniesByUserIdAndRoleId(String userId, String roleId, String sourceType, String companyId);

	/**
	 * 查询用户的根组织
	 * 
	 * @param userId
	 * @param roleId
	 * @param sourceType
	 * @return
	 */
	List<CompanyVO> getTopCompaniesByUserIdAndRoleId(String userId, String roleId, String sourceType);

	/**
	 * 查询用户的根组织
	 */
	List<CompanyVO> getTopCompaniesByUserId(String userId);

	public long countAllStaffsByCompanyId(String param, String companyId);

	public List<StaffUnionVO> searchAllStaffsByCompanyId(String param, String companyId, int startIndex, int pageSize);

	public long countStaffsByDeptId(String param, String deptId);

	public long countStaffsByDeptId(String param, String deptId, List<String> positionIds);
	
	public long countStaffsByDeptId(String param, String deptId, List<String> positionIds, int property);

	public List<StaffUnionVO> searchStaffsByDeptId(String param, String deptId, int startIndex, int pageSize);

	public List<StaffUnionVO> searchStaffsByDeptId(String param, String deptId, List<String> positionIds,
			int startIndex, int pageSize);
	
	List<StaffUnionVO> searchStaffsByDeptId(String param, String deptId, List<String> positionIds, int property,
			int startIndex, int pageSize);

	public List<StaffUnionVO> searchStaffsByDeptIdNew(String param, String deptId, int startIndex, int pageSize);

	List<String> getUserIdsByPositionDictIds(String companyId, String[] positionIds);

	List<String> getUserIdsByPositionDictIds(String[] companyIds, String[] positionIds);

	/**
	 * 通过岗位ID检查是否被引用
	 * 
	 * @param id
	 * @return
	 */
	public Integer countStaffsByPositionId(String id);

	Boolean deleteStaff(String id) throws Exception;

	/**
	 * 创建供应商和特种作业人员及用户
	 * 
	 * @param code
	 *            人员编码
	 * @param name
	 *            人员名称
	 * @param companyId
	 *            所属组织
	 * @param deptId
	 *            所属部门
	 * @param tel
	 *            手机号
	 * @param creditCode
	 *            证件号码
	 * @param address
	 *            家庭住址
	 * @param supplierDocId
	 *            供应商档案主键id
	 * @param otherProp
	 *            人员其他属性数组，通过key,value,key,valye...形式传递
	 * @return
	 */
	Pair createOrUpdateStaffAndUser(String code, String name, String companyId, String deptId, String tel,
			String creditCode, String address, String supplierDocId, String... otherProps);

	/**
	 * 人员调动
	 * 
	 * @param companyId
	 * @param deptId
	 * @param jobTime
	 * @param movePositionId
	 * @param staffIds
	 */
	public void moveStaff(String companyId, String deptId, String jobTime, String movePositionId,
			List<String> staffIds);
	
	/**
	 * 人员复职
	 * 
	 * @param params 复职参数
	 */
	public List<StaffPartJobVO> renewStaff(JSONObject params) throws BusinessException;

	/**
	 * 供应商人员新增修改接口
	 * 
	 * @param staffList
	 *            数据列表
	 * @param actionType
	 *            数据操作类型：add-新增/ edit-编辑
	 * @param isAdd
	 *            是否新增，执行更新操作时，如果数据不存在是否执行新增操作, true-执行，false-不执行
	 * @return
	 */
	public List<SupplierStaffVO> supplierStaffManager(List<SupplierStaffVO> staffList, String actionType, String isAdd);

	/**
	 * 根据身份证号查询对应的人员Map<人员身份证号，人员>
	 * 
	 * @param credentialCodes
	 * @return
	 */
	public Map<String, StaffVO> getStaffsMapByCredentialcodes(List<String> credentialCodes);

	/**
	 * 根据身份证号查询对应的人员列表
	 * 
	 * @param credentialCodes
	 * @return
	 */
	public List<StaffVO> getAllStaffByCredentialcodes(List<String> credentialCodes);

	/**
	 * 根据组织ID获取项目部授权的所有该组织下的直属、隶属人员的数量
	 *
	 * @param companyId
	 * @param param
	 * @return
	 */
	public List<ProjectDeptAuthStaffVO> getStaffAndJobPartCountByCompanyId(String companyId, String param);

	/**
	 * 根据组织ID获取项目部授权的所有组织下的直属、隶属人员的详细信息
	 * 
	 * @param companyId
	 * @param param
	 * @param pageNumber
	 * @param pageSize
	 * @return
	 */
	public List<ProjectDeptAuthStaffVO> getProjectDeptAuthStaffVOByCompanyId(String companyId, String param,
			int pageNumber, int pageSize);

	/**
	 * 根据部门ID获取项目部授权的所有部门下的直属、隶属人员的数量
	 * 
	 * @param deptId
	 * @param param
	 * @return
	 */
	public List<ProjectDeptAuthStaffVO> getStaffAndJobPartCountByDeptId(String deptId, String param);

	/**
	 * 根据部门ID获取项目部授权的所有部门下的直属、隶属人员的详细信息
	 * 
	 * @param deptId
	 * @param param
	 * @param pageNumber
	 * @param pageSize
	 * @return
	 */
	public List<ProjectDeptAuthStaffVO> getProjectDeptAuthStaffVOByDeptId(String deptId, String param, int pageNumber,
			int pageSize);

	/**
	 * 逻辑删除指定的供应商人员对应的任职记录
	 * 
	 * @param stafflist
	 * @return
	 */
	/*
	 * List<SupplierStaffVO> delSupplierStaffWrokExpr(List<SupplierStaffVO>
	 * stafflist);
	 */

	/**
	 * 当修改用户时，维护人员表中的用户的冗余字段
	 * 
	 * @param vo
	 */
	void updateStaffWhenUserChanged(UserBaseVO vo);

	/**
	 * 注册_根据手机号码获取人员
	 */
	public List<StaffVO> getStaffsByMobileForRegist(List<String> mobile);

	/**
	 * 注册_新增人员
	 */
	public StaffVO saveStaffForRegist(JSONObject paramJson, String tenantId, JSONObject saveMsg);

	/**
	 * 获取组织下未激活人员数量
	 */
	public Integer getNoActiveCount(String orgInnercode);

	/**
	 * 获取组织下未激活人员列表
	 */
	public List<StaffVO> findNoActiveStaffPage(String orgInnercode, int pageNo, int pageSize);

	/**
	 * 获取组织下未分配人员数量
	 */
	public Integer getNoDeptStaffCount(String orgInnercode);

	/**
	 * 获取组织下未分配人员列表
	 */
	public List<StaffVO> findNoDeptStaffPage(String orgInnercode, int pageNo, int pageSize);

	/**
	 * 获取指定部门下的人员数量
	 */
	public Integer getStaffCountByDept(String deptId);

	/**
	 * 获取指定部门下的人员列表
	 */
	public List<StaffVO> findStaffUserByDept(String deptId);

	/**
	 * 团队管理_人员搜索_分页
	 * 
	 * @param type:为空表示所有，“0”表示搜索未分配人员，“1”表示搜索未激活人员
	 */
	public List<StaffVO> searchStaffPageForTeammgr(String companyId, String searchKey, int pageNumber, int pageSize,
			String type);

	public int getCodeCountByStaffId(String code, String staffId);

	public int getMobileCountByStaffId(String mobile, String staffId);

	public int getCredentialCodeCountByStaffId(String credentialCode, String staffId);

	public int getEmailCountByStaffId(String credentialCode, String staffId);

	public List<BdStaffVO> findStaffByIds(List<String> ids);

	public List<StaffPartJobVO> findAllPartJobVOsByStaffId(String id);

	public int getCountByByCompanyIdAllNew(String deptId, List<String> userid, String searchText);

	public int getCountByDeptIdAllNew(List<String> deptId, List<String> userid, String searchText);

	List<StaffVO> searchStaffsByDeptIdAllNew(List<String> deptIds, List<String> userid, String searchText, int pageNew,
			int pageSize);

	List<StaffVO> searchStaffsByCompanyIdAllNew(String companyId, List<String> userid, String searchText, int pageNew,
			int pageSize);

	public List<StaffVO> getStaffsByUserList(List<String> userIds);

	/**
	 * 修改人员的身份证号
	 * 
	 * @param staffId
	 *            人员id
	 * @param idNum
	 *            新的身份证号
	 * @return 人员对象
	 */
	public StaffVO modifyIDNumber(String staffId, String idNum);

	/**
	 * 根据code查询人员信息
	 * 
	 * @param code
	 *            人员code
	 * @return 人员对象
	 */
	public StaffVO getStaffByCode(String code);

	/**
	 * 根据code查询人员信息
	 * 
	 * @param condition
	 *            姓名或手机或邮箱或部门名称
	 * @param companyId
	 *            组织id，当组织
	 * @return 人员对象list
	 */
	public List<StaffVO> getStaffByCondition(String condition, String companyId);

	/**
	 * 根据登录用户ID：userId 查询(在职的)主职、兼职的岗位IDS：posIds
	 * 
	 * @param userId
	 *            登录用户ID
	 * @return
	 */
	List<String> queryPositionIdsByUserId(String userId);

	/**
	 * 根据用户ID：userId 查询(在职的)主职、兼职的对象
	 * 
	 * @param userId
	 *            登录用户ID
	 * @return
	 */
	List<StaffPartJobVO> queryStaffPartJobVOByUserId(String userId);

	/**
	 * 根据登录用户ID：userId 查询(在职的)主职、兼职的所属组织IDS：belongCompanyIds
	 * 
	 * @param userId
	 *            登录用户ID
	 * @return
	 */
	List<String> queryBelongCompanyIdsByUserId(String userId);

	/**
	 * 根据人员姓名查找人员
	 * 
	 * @param names
	 *            人员姓名列表
	 * @param tenantId
	 *            租户ID
	 * @return JSONObject
	 */
	public JSONObject findStaffsByName(List<String> names, String tenantId);

	/**
	 * 修改人员的属性
	 * 
	 * @param staffId
	 *            人员id
	 * @param property
	 *            新的属性
	 * @return 人员对象
	 */
	public StaffVO modifyStaffByProperty(String staffId, Map<String, Object> property) throws Exception;

	/**
	 * 通过岗位ID检查是否被引用
	 * 
	 * @param id
	 *            岗位ID
	 * @return map 包含人员总数和岗位名称
	 */
	public Map<String, Object> countStaffByPositionId(String id);

	public int countPartStaffByDept(String deptId);

	/**
	 * <p>
	 * 分页查询公司本下级职能组织的人员信息
	 * </p>
	 * 
	 * @param orgCompanyId
	 *            职能组织ID
	 * @param searchText
	 *            搜索文本
	 * @param pageNumber
	 *            页码
	 * @param pageSize
	 *            每页记录数
	 * @param orderCondition
	 *            排序字段（以，隔开）
	 * @return org.springframework.data.domain.Page&lt;com.yyjz.icop.orgcenter.
	 *         staff.vo.OrgStaffRefVO&gt;
	 * @author zhangxn
	 * @date 2018/2/2 18:01
	 */
	public Page<OrgStaffRefVO> getOrgStaffRef(String orgCompanyId, String searchText, int pageNumber, int pageSize,
			String orderCondition);

	/**
	 * 根据sourceId查询人员
	 */
	public StaffVO getStaffBySourceId(String sourceId);

	/**
	 * 保存人员类型（因为没权限对外公布dubbo接口，因此放在此处）
	 * 
	 * @param vo
	 * @return
	 * @throws Exception
	 */
	public StaffTypeVO saveWithVerify(StaffTypeVO vo) throws Exception;

	/**
	 * 根据编码查询对应的人员类别（因为没权限对外公布dubbo接口，因此放在此处）
	 * 
	 * @param code
	 * @return
	 */
	public StaffTypeVO findStaffTypeByCode(String code);

	/**
	 * 保存人员，如果人员信息有误则抛出错误原因，最终都要将人员保存(移动同步建总hr数据)
	 * 
	 * @param staff
	 * @return
	 * @throws Exception
	 */
	public StaffVO pushStaff(StaffVO staff, List<StaffPartJobVO> partJobVOs) throws Exception;

	/**
	 * hr同步_保持人员校验
	 */
	public String checkAddStaff(StaffVO staff);
	
	/**
	 * 人员注销
	 * @param staffVO
	 * @return
	 */
	boolean logoutStaff(String staffId, List<String> partStaffIds);
	
	/**
	 * 查询当前部门下人员任职记录
	 * @param deptId
	 * @param staffId
	 * @param tenantId
	 * @return
	 */
	List<StaffUnionVO> listByDeptAndStaff(String deptId, String staffId, String tenantId, int property);
	
	List<StaffPartJobVO> listByIds(List<String> staffIds, List<Integer> props, List<Integer> states) throws BusinessException;
	
	/**
	 * 通过用户id，获取人员签名文件路径
	 * @param userId
	 * @return
	 */
	String getAutographPathByUserId(String userId) throws BusinessException;
	
	/**
	 * 通过用户ids列表，获取人员签名文件路径列表
	 * @param userIds
	 * @param tenantId 
	 * @return Map<String, String>
	 */
	Map<String, String> getAutographPathsByUserIds(List<String> userIds, String tenantId) throws BusinessException;

	// add by guoming
	public long countOrgFunUser(Map<String, Object> queryMap);

	public List<StaffUnionVO> orgFunRelaionUserRef(Map<String, Object> map);

	public int countOrgFunUserRefByDeptId(List<String> deptIds, List<String> notInUserid,List<String> inUids, String searchText);

	public List<StaffVO> orgFunRelaionUserRefByDeptIds(List<String> deptIds, List<String> notInUids,List<String> inUids, String searchText,
			int pageNum, int pageSize);

	public int countOrgFunUserRefByCompanyId(String companyId, List<String> notInUids,List<String> inUids, String searchText);

	public List<StaffVO> orgFunRelaionUserRefByCompanyId(String companyId, List<String> notInUids,List<String> inUids, String searchText,
			int pageNum, int pageSize);

	public List<String> getOrgFunUidsByCompanyId(String companyId, List<String> orgFunRelationUids, String searchText);

	List<StaffVO> searchStaffsByCompanyIdAllOrg(String companyId,
			List<String> userid,List<String> notUserId, String searchText, int pageNew, int pageSize);

	List<StaffVO> searchStaffsByDeptIdAllOrg(List<String> deptIds,
			List<String> userid,List<String> notUserId, String searchText, int pageNew, int pageSize);

	int getCountByDeptIdAllOrg(List<String> deptId, List<String> userid,List<String> notUserId,
			String searchText);

	int getCountByByCompanyIdAllOrg(String deptId, List<String> userid,List<String> notUserId,
			String searchText);
	// end by guoming

	public int countUsersByCompanyId(Map<String, Object> paramMap);

	public List<StaffUnionVO> queryUsersByCompanyId(Map<String, Object> paramMap);

	public int countByDeptIdAllOrg(List<String> deptIds, List<String> includOrgFunIds, String searchText);

	public List<StaffVO> searchStaffsByDeptIdAllOrg(List<String> deptIds, List<String> includOrgFunIds,
			String searchText, int pageNum, int pageSize);

	public int getCountByByCompanyIdAllOrg(String companyId, List<String> includOrgFunIds, String searchText);

	public List<StaffVO> searchStaffsByCompanyIdAllOrg(String companyId, List<String> includOrgFunIds, String searchText,
			int pageNum, int pageSize);


	/**
	 * 根据条件查询指定组织下指定的用户(直属+隶属)的数量（结果按用户去重）
	 *
	 * @return
	 */
	public Long countUsersWithNorepetition(String companyId, List<String> userIds, boolean isContainbelow, String searchText);

	/**
	 * 根据条件查询指定组织下指定的用户(直属+隶属)的信息（结果按用户去重）
	 *
	 * @param queryParam
	 * @return
	 */
	public List<StaffVO> queryUsersWithNorepetition(String companyId, List<String> userIds, String searchText, boolean isContainbelow, int startLine, int pageSize);
}