package com.yyjz.icop.orgcenter.staff.service;

import java.util.Iterator;
import java.util.List;

import com.yyjz.icop.orgcenter.staff.vo.StaffTypeVO;

public interface StaffTypeService {

	/**
	 * 
	 * @return
	 */
	public List<StaffTypeVO> getAllStaffType();

	public String findStaffTypeIsRootMax();

	public StaffTypeVO getStaffTypeById(String pId);

	public String getMaxInnercode(String pId);

	public void save(StaffTypeVO staffTypeVO);
	
	public StaffTypeVO saveWithVerify(StaffTypeVO vo) throws Exception;

	public StaffTypeVO findStaffTypeById(String id);

	public String getInnercodeById(String id);

	public List<String> queryAllParent(String pid, String id);

	public boolean hasChild(String next);

	public void deleteOne(String next);

	public void hasChildListDelete(String next);

	public void oneDelete(String next);

	public StaffTypeVO getRefStaffTypeByRelyCondition(String relyCondition);

	public List<StaffTypeVO> getStaffTypeByName(String searchText);

	public Boolean findStaffTypeByIdAndCode(StaffTypeVO vo);

	public StaffTypeVO findLastStaffByNames(String names, String split);

	/**
	 * 根据编码查询对应的人员类别
	 * 
	 * @param code
	 * @return
	 */
	public StaffTypeVO findStaffTypeByCode(String code);

	public boolean isReturn(Iterator<String> projectIterator);

}
