package com.yyjz.icop.orgcenter.staff.service.api;

import com.yyjz.icop.orgcenter.staff.vo.StaffUnionVO;
import com.yyjz.icop.orgcenter.staff.vo.StaffVO;
import org.springframework.data.domain.PageRequest;

import java.util.List;

/**
 * 人员服务类
 * @Description: 此服务类所有借口都添加公司enabled字段过滤
 * @Author: zhangxn
 * @CreateDate: 2018/3/26 9:23
 */
public interface EnabledStaffService {
		/**
		 * <p>获取当前部门下没有兼职的人员总数</p>
		 * @param partCompanyId 兼职公司
		 * @param deptId 兼职部门
		 * @param searchText 搜索条件
		 * @param curCompanyId 当前公司
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.staff.vo.StaffVO>
		 * @author zhangxn
		 * @date 2018/3/26 10:08
		 */
		long getNoPartStaffCount(String partCompanyId, String deptId, String curCompanyId, String searchText, int enabled);

		/**
		 * <p>获取当前部门下没有兼职的人员</p>
		 * @param partCompanyId 兼职公司
		 * @param deptId 兼职部门
		 * @param param 搜索条件
		 * @param curCompanyId 当前公司
		 * @param enabled 是否启用 0：启用 1：停用 其他：全部
		 * @return java.util.List<com.yyjz.icop.orgcenter.staff.vo.StaffVO>
		 * @author zhangxn
		 * @date 2018/3/26 10:08
		 */
		List<StaffVO> getNoPartStaff(String partCompanyId, String deptId, String param, String curCompanyId, int pageNumber, int pageSize, int enabled);

		/**
		 * <p>根据公司ID获取本下直属人员数目</p> <p style="color:red">注意：只包括直属人员</p>
		 * @param param 搜索条件
		 * @param companyId 公司ID
		 * @return long 符合条件的人员数量
		 * @author zhangxn
		 * @date 2018/3/26 13:56
		 */
		public long countAllStaffsByCompanyId(String param, String companyId, int enabled);
		
		long countAllStaffsByCompanyId(String param, String companyId, int property, int enabled);

		/**
		 * <p>根据公司ID获取本下直属人员</p> <p style="color:red">注意：注意：只包括直属人员</p>
		 * @param param 搜索条件
		 * @param companyId 公司ID
		 * @param startIndex
		 * @param pageSize
		 * @return java.util.List<com.yyjz.icop.orgcenter.staff.vo.StaffUnionVO>
		 * @author zhangxn
		 * @date 2018/3/26 13:57
		 */
		public List<StaffUnionVO> searchAllStaffsByCompanyId(String param, String companyId, int startIndex, int pageSize,int enabled);
		List<StaffUnionVO> searchAllStaffsByCompanyId(String param, String companyId, int property, int startIndex, int pageSize, int enabled);
		
		public List<StaffUnionVO> searchAllStaffsByCompanyIdNew(String param, String companyId, int startIndex, int pageSize,int enabled);
}
