package com.yyjz.icop.orgcenter.staff.vo;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import com.yyjz.icop.base.vo.SuperVO;

public class StaffPartJobVO extends SuperVO {
	private static final long serialVersionUID = 7853531732698603006L;

	private String staffId;// 人员Id

	private String staffName;// 人员名称

	private String deptId;// 人员所属部门

	private String deptName;

	private String companyId;// 人员所属公司表

	private String companyName;

	private String positionId;// 岗位

	private String positon;

	private Integer property;// 属性, 分别是兼职和主职

	private Timestamp jobStartTime;// 该职位开始任职的时间

	private Timestamp jobEndTime;// 该职位离职时间

	private Timestamp jobTime;// 接受前端的时间

	public String getJobStartTime() { // 用户Json解析
		return jobStartTime == null ? null : new SimpleDateFormat("yyyy-MM-dd")
				.format(jobStartTime);
	}

	public Timestamp getJobStartTime2() {// vo 属性复制到 entity
		return jobStartTime == null ? new Timestamp(System.currentTimeMillis())
				: jobStartTime;
	}

	public Timestamp getJobEndTime2() {// vo 属性复制到 entity
		return jobEndTime;
	}

	public void setJobStartTime(Timestamp jobStartTime) {
		this.jobStartTime = jobStartTime;
	}

	public String getJobEndTime() {
		return jobEndTime == null ? null : new SimpleDateFormat("yyyy-MM-dd")
				.format(jobEndTime);
	}

	public void setJobEndTime(Timestamp jobEndTime) {
		this.jobEndTime = jobEndTime;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	private int curState;

	public Timestamp getJobTime() {
		return jobTime;
	}

	public void setJobTime(Timestamp jobTime) {
		this.jobTime = jobTime;
	}

	public int getCurState() {
		return curState;
	}

	public void setCurState(int curState) {
		this.curState = curState;
	}

	private String propertyName;// 职务类型名称

	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	public String getCompanyId() {
		return companyId;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getPositionId() {
		return positionId;
	}

	public void setPositionId(String positionId) {
		this.positionId = positionId;
	}

	public String getPositon() {
		return positon;
	}

	public void setPositon(String positon) {
		this.positon = positon;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

	public Integer getProperty() {
		return property;
	}

	public void setProperty(Integer property) {
		this.property = property;
	}

	public String getStaffId() {
		return staffId;
	}

	public void setStaffId(String staffId) {
		this.staffId = staffId;
	}

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}

	@Override
	public String toString() {
		return "StaffPartJobVO [staffId=" + staffId + ", staffName=" + staffName + ", deptId=" + deptId + ", deptName=" + deptName + ", companyId=" + companyId + ", companyName=" + companyName
				+ ", positionId=" + positionId + ", positon=" + positon + ", property=" + property + ", jobStartTime=" + jobStartTime + ", jobEndTime=" + jobEndTime + ", jobTime=" + jobTime
				+ ", curState=" + curState + ", propertyName=" + propertyName + "]";
	}
	
}
