package com.yyjz.icop.orgcenter.staff.vo;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import org.springframework.jdbc.core.RowMapper;

import com.yyjz.icop.base.entity.AbsIdEntity;

public class StaffUnionVO extends AbsIdEntity implements RowMapper<StaffUnionVO>{
	private static final long serialVersionUID = 1544023434308856628L;

	public StaffUnionVO(){
	}

	private Long order;

	private String code;// 员工编码

	private String name;// 员工姓名

	private Integer sex; // 性别

	private Date birthday;// 出生年月日

	private String deptId;// 人员所属部门

	private String companyId;// 人员所属公司表

	private EnumStatus status;// 员工状态，在职，离职

	private String nativePlace;// 籍贯

	private String education;// 学历

	private String politicalStatus;// 政治面貌

	private String major;// 所学专业

	private String school;// 毕业学校

	private Date graduationTime;// 毕业时间

	private Date workTime;// 参加工作时间

	private String credentialCode;// 证件号码

	private String mobile;// 移动电话

	private String signPic;// 签名图片

	private String landlineNum;// 座机号

	private String age;// 年龄

	private String post;// 职位

	private String positionId;// 岗位Id

	private String dept;// 部门

	private String company;// 公司

	private String email;// 邮箱

	private String userId;// 用户关联人员

	private Integer isUser;// 是否关联人员

	private Integer credentialType;// 证件类型

	private String address;// 地址

	private String staffTypeId;// 人员id

	private Integer property;// 直属或隶属
	private String staffState;// 人员状态
	private Integer curState;

	// 扩展
	private String partId;
	private String userName;
	private String userCode;
	private String positionName;
	private Timestamp jobStartTime;// 该职位开始任职的时间
	private Timestamp jobEndTime;//

	public String getJobStartTime(){
		return jobStartTime == null ? null : new SimpleDateFormat("yyyy-MM-dd").format(jobStartTime);
	}

	public void setJobStartTime(Timestamp jobStartTime){
		this.jobStartTime = jobStartTime;
	}
	
	public String getJobEndTime(){
		return jobEndTime == null ? null : new SimpleDateFormat("yyyy-MM-dd").format(jobEndTime);
	}

	public void setJobEndTime(Timestamp jobEndTime){
		this.jobEndTime = jobEndTime;
	}

	public String getCompany(){
		return company;
	}

	public void setCompany(String company){
		this.company = company;
	}

	public String getPartId(){
		return partId;
	}

	public void setPartId(String partId){
		this.partId = partId;
	}

	public String getPositionName(){
		return positionName;
	}

	public void setPositionName(String positionName){
		this.positionName = positionName;
	}

	public String getUserName(){
		return userName;
	}

	public void setUserName(String userName){
		this.userName = userName;
	}

	public Long getOrder(){
		return order;
	}

	public void setOrder(Long order){
		this.order = order;
	}

	public String getProperty(){
		return property == null || property == 0 ? "直属" : "隶属";
	}

	public void setProperty(Integer property){
		this.property = property;
	}

	public Integer getCurState(){
		return curState;
	}

	public void setCurState(Integer curState){
		this.curState = curState;
	}

	public String getPositionId(){
		return positionId;
	}

	public void setPositionId(String positionId){
		this.positionId = positionId;
	}

	public String getAddress(){
		return address;
	}

	public void setAddress(String address){
		this.address = address;
	}

	public String getStaffTypeId(){
		return staffTypeId;
	}

	public void setStaffTypeId(String staffTypeId){
		this.staffTypeId = staffTypeId;
	}

	public Integer getCredentialType(){
		return credentialType;
	}

	public void setCredentialType(Integer credentialType){
		this.credentialType = credentialType;
	}

	public Integer getIsUser(){
		return isUser;
	}

	public void setIsUser(Integer isUser){
		this.isUser = isUser;
	}

	public String getUserId(){
		return userId;
	}

	public void setUserId(String userId){
		this.userId = userId;
	}

	public String getLandlineNum(){
		return landlineNum;
	}

	public void setLandlineNum(String landlineNum){
		this.landlineNum = landlineNum;
	}

	public String getDeptId(){
		return deptId;
	}

	public void setDeptId(String deptId){
		this.deptId = deptId;
	}

	public String getCompanyId(){
		return companyId;
	}

	public void setCompanyId(String companyId){
		this.companyId = companyId;
	}

	public String getAge(){
		return age;
	}

	public void setAge(String age){
		this.age = age;
	}

	public String getPost(){
		return post;
	}

	public void setPost(String post){
		this.post = post;
	}

	public String getPosition(){
		return positionId;
	}

	public void setPosition(String position){
		this.positionId = position;
	}

	public String getDept(){
		return dept;
	}

	public void setDept(String dept){
		this.dept = dept;
	}

	public String getEmail(){
		return email;
	}

	public void setEmail(String email){
		this.email = email;
	}

	public String getCode(){
		return code;
	}

	public void setCode(String code){
		this.code = code;
	}

	public String getName(){
		return name;
	}

	public void setName(String name){
		this.name = name;
	}

	public Date getBirthday(){
		return birthday;
	}

	public Integer getSex(){
		return sex;
	}

	public void setSex(Integer sex){
		this.sex = sex;
	}

	public void setBirthday(Date birthday){
		this.birthday = birthday;
	}

	public EnumStatus getStatus(){
		return status;
	}

	public void setStatus(EnumStatus status){
		this.status = status;
	}

	public String getNativePlace(){
		return nativePlace;
	}

	public void setNativePlace(String nativePlace){
		this.nativePlace = nativePlace;
	}

	public String getEducation(){
		return education;
	}

	public void setEducation(String education){
		this.education = education;
	}

	public String getPoliticalStatus(){
		return null;
	}

	public void setPoliticalStatus(String politicalStatus){
		this.politicalStatus = politicalStatus;
	}

	public String getMajor(){
		return major;
	}

	public void setMajor(String major){
		this.major = major;
	}

	public String getSchool(){
		return school;
	}

	public void setSchool(String school){
		this.school = school;
	}

	public Date getGraduationTime(){
		return graduationTime;
	}

	public void setGraduationTime(Date graduationTime){
		this.graduationTime = graduationTime;
	}

	public Date getWorkTime(){
		return workTime;
	}

	public void setWorkTime(Date workTime){
		this.workTime = workTime;
	}

	public String getCredentialCode(){
		return credentialCode;
	}

	public void setCredentialCode(String credentialCode){
		this.credentialCode = credentialCode;
	}

	public String getMobile(){
		return mobile;
	}

	public void setMobile(String mobile){
		this.mobile = mobile;
	}

	public String getSignPic(){
		return signPic;
	}

	public void setSignPic(String signPic){
		this.signPic = signPic;
	}

	public String getStaffState(){
		return staffState;
	}

	public void setStaffState(String staffState){
		this.staffState = staffState;
	}

	private boolean isExistColumn(ResultSet rs, String columnName){
		try{
			if(rs.findColumn(columnName) > 0){
				return true;
			}
		}catch(SQLException e){
			return false;
		}

		return false;
	}

	@Override
	public StaffUnionVO mapRow(ResultSet rs, int row) throws SQLException{
		StaffUnionVO vo = new StaffUnionVO();
		if(isExistColumn(rs, "address"))
			vo.setAddress(rs.getString("address"));
		if(isExistColumn(rs, "age"))
			vo.setAge(rs.getString("age"));
		if(isExistColumn(rs, "birthday"))
			vo.setBirthday(rs.getDate("birthday"));
		if(isExistColumn(rs, "code"))
			vo.setCode(rs.getString("code"));
		if(isExistColumn(rs, "companyId"))
			vo.setCompanyId(rs.getString("companyId"));
		if(isExistColumn(rs, "company"))
			vo.setCompany(rs.getString("company"));
		if(isExistColumn(rs, "creationtime"))
			vo.setCreationTimestamp(rs.getTimestamp("creationtime"));
		if(isExistColumn(rs, "credentialCode"))
			vo.setCredentialCode(rs.getString("credentialCode"));
		if(isExistColumn(rs, "credentialType")){
			vo.setCredentialType(rs.getInt("credentialType"));
			if(rs.wasNull()){
				vo.setCredentialType(null);
			}
		}
		if(isExistColumn(rs, "dept"))
			vo.setDept(rs.getString("dept"));
		if(isExistColumn(rs, "deptId"))
			vo.setDeptId(rs.getString("deptId"));
		if(isExistColumn(rs, "dr"))
			vo.setDr(rs.getInt("dr"));
		if(isExistColumn(rs, "education"))
			vo.setEducation(rs.getString("education"));
		if(isExistColumn(rs, "email"))
			vo.setEmail(rs.getString("email"));
		if(isExistColumn(rs, "graduationTime"))
			vo.setGraduationTime(rs.getDate("graduationTime"));
		if(isExistColumn(rs, "id"))
			vo.setId(rs.getString("id"));
		if(isExistColumn(rs, "partId"))
			vo.setPartId(rs.getString("partId"));
		if(isExistColumn(rs, "isUser"))
			vo.setIsUser(rs.getInt("isUser"));
		if(isExistColumn(rs, "landlineNum"))
			vo.setLandlineNum(rs.getString("landlineNum"));
		if(isExistColumn(rs, "major"))
			vo.setMajor(rs.getString("major"));
		if(isExistColumn(rs, "mobile"))
			vo.setMobile(rs.getString("mobile"));
		if(isExistColumn(rs, "lastmodifiedtime"))
			vo.setModificationTimestamp(rs.getTimestamp("lastmodifiedtime"));
		if(isExistColumn(rs, "name"))
			vo.setName(rs.getString("name"));
		if(isExistColumn(rs, "nativePlace"))
			vo.setNativePlace(rs.getString("nativePlace"));
		if(isExistColumn(rs, "politicalStatus"))
			vo.setNativePlace(rs.getString("politicalStatus"));
		if(isExistColumn(rs, "positionId"))
			vo.setPositionId(rs.getString("positionId"));
		if(isExistColumn(rs, "positionName"))
			vo.setPositionName(rs.getString("positionName"));
		if(isExistColumn(rs, "post"))
			vo.setPost(rs.getString("post"));
		if(isExistColumn(rs, "property"))
			vo.setProperty(rs.getInt("property"));
		if(isExistColumn(rs, "curState"))
			vo.setCurState(rs.getInt("curState"));
		if(isExistColumn(rs, "school"))
			vo.setSchool(rs.getString("school"));
		if(isExistColumn(rs, "sex")){
			vo.setSex(rs.getInt("sex"));
			if(rs.wasNull()){
				vo.setSex(null);
			}
		}
		if(isExistColumn(rs, "signPic"))
			vo.setSignPic(rs.getString("signPic"));
		if(isExistColumn(rs, "staffTypeId"))
			vo.setStaffTypeId(rs.getString("staffTypeId"));
		if(isExistColumn(rs, "status"))
			vo.setStatus(rs.getString("status") == null || "".equals(rs.getString("status").trim()) ? null
					: EnumStatus.valueOf(rs.getString("status")));
		if(isExistColumn(rs, "userId"))
			vo.setUserId(rs.getString("userId"));
		if(isExistColumn(rs, "workTime"))
			vo.setWorkTime(rs.getDate("workTime"));
		if(isExistColumn(rs, "order"))
			vo.setOrder(rs.getLong("order"));
		if(isExistColumn(rs, "jobStartTime"))
			vo.setJobStartTime(rs.getTimestamp("jobStartTime"));
		if(isExistColumn(rs, "jobEndTime"))
			vo.setJobEndTime(rs.getTimestamp("jobEndTime"));
		if(isExistColumn(rs, "userCode"))
			vo.setUserCode(rs.getString("userCode"));
		if(isExistColumn(rs, "userName"))
			vo.setUserName(rs.getString("userName"));
		if(isExistColumn(rs, "staffState"))
			vo.setStaffState(rs.getString("staffState"));

		return vo;
	}

	public String getUserCode(){
		return userCode;
	}

	public void setUserCode(String userCode){
		this.userCode = userCode;
	}
}