package com.yyjz.icop.orgcenter.staff.vo;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

/**
 * 任职记录
 * 
 * @author CJ
 * 
 * @version 1.0.0
 * 
 */
public class WorkExperienceVO implements Serializable {
	private static final long serialVersionUID = 7853531732698603006L;
	
	public static final Integer WORKER_TYPE_SUPPLIERSTAFF = 0;
	public static final Integer WORKER_TYPE_LEGALPERSON = 1;
	public static final Integer WORKER_TYPE_PARTMEMBER = 2;
	
	private String id;
	
	private int dr;

	private String workerId;// 人员Id

	private String workerName;// 人员名称

	private String deptId;// 人员所属部门

	private String deptName;

	private String companyId;// 人员所属公司表

	private String companyName;

	private String positionId;// 岗位

	private String positon;

	private Integer property;// 属性, 分别是兼职和主职

	private Timestamp jobStartTime;// 该职位开始任职的时间

	private Timestamp jobEndTime;// 该职位离职时间

	private Timestamp jobTime;// 接受前端的时间
	
	private int workerType;	//当前人类型：0-特种人员，1-法人，2-党员
	
	private Timestamp creationTimestamp;
	private Timestamp modificationTimestamp;
	
	private String spareParam1;
	private String spareParam2;
	private String spareParam3;
	private String spareParam4;
	private String spareParam5;
	
	
	public Timestamp getCreationTimestamp() {
		return creationTimestamp;
	}

	public void setCreationTimestamp(Timestamp creationTimestamp) {
		this.creationTimestamp = creationTimestamp;
	}

	public Timestamp getModificationTimestamp() {
		return modificationTimestamp;
	}

	public void setModificationTimestamp(Timestamp modificationTimestamp) {
		this.modificationTimestamp = modificationTimestamp;
	}

	public int getWorkerType() {
		return workerType;
	}

	public void setWorkerType(int workerType) {
		this.workerType = workerType;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public int getDr() {
		return dr;
	}

	public void setDr(int dr) {
		this.dr = dr;
	}

	public String getJobStartTime() { // 用户Json解析
		return jobStartTime == null ? null : new SimpleDateFormat("yyyy-MM-dd")
				.format(jobStartTime);
	}

	public Timestamp getJobStartTime2() {// vo 属性复制到 entity
		return jobStartTime == null ? new Timestamp(System.currentTimeMillis())
				: jobStartTime;
	}

	public Timestamp getJobEndTime2() {// vo 属性复制到 entity
		return jobEndTime;
	}

	public void setJobStartTime(Timestamp jobStartTime) {
		this.jobStartTime = jobStartTime;
	}

	public String getJobEndTime() {
		return jobEndTime == null ? null : new SimpleDateFormat("yyyy-MM-dd")
				.format(jobEndTime);
	}

	public void setJobEndTime(Timestamp jobEndTime) {
		this.jobEndTime = jobEndTime;
	}

	public String getPropertyName() {
		return propertyName;
	}

	public void setPropertyName(String propertyName) {
		this.propertyName = propertyName;
	}

	private int curState;

	public Timestamp getJobTime() {
		return jobTime;
	}

	public void setJobTime(Timestamp jobTime) {
		this.jobTime = jobTime;
	}

	public int getCurState() {
		return curState;
	}

	public void setCurState(int curState) {
		this.curState = curState;
	}

	private String propertyName;// 职务类型名称

	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	public String getCompanyId() {
		return companyId;
	}

	public String getDeptName() {
		return deptName;
	}

	public void setDeptName(String deptName) {
		this.deptName = deptName;
	}

	public String getCompanyName() {
		return companyName;
	}

	public void setCompanyName(String companyName) {
		this.companyName = companyName;
	}

	public String getPositionId() {
		return positionId;
	}

	public void setPositionId(String positionId) {
		this.positionId = positionId;
	}

	public String getPositon() {
		return positon;
	}

	public void setPositon(String positon) {
		this.positon = positon;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

	public Integer getProperty() {
		return property;
	}

	public void setProperty(Integer property) {
		this.property = property;
	}
	
	public String getWorkerId() {
		return workerId;
	}

	public void setWorkerId(String workerId) {
		this.workerId = workerId;
	}
	
	public String getWorkerName() {
		return workerName;
	}

	public void setWorkerName(String workerName) {
		this.workerName = workerName;
	}
	
	
	
	public String getSpareParam1() {
		return spareParam1;
	}

	public void setSpareParam1(String spareParam1) {
		this.spareParam1 = spareParam1;
	}

	public String getSpareParam2() {
		return spareParam2;
	}

	public void setSpareParam2(String spareParam2) {
		this.spareParam2 = spareParam2;
	}

	public String getSpareParam3() {
		return spareParam3;
	}

	public void setSpareParam3(String spareParam3) {
		this.spareParam3 = spareParam3;
	}

	public String getSpareParam4() {
		return spareParam4;
	}

	public void setSpareParam4(String spareParam4) {
		this.spareParam4 = spareParam4;
	}

	public String getSpareParam5() {
		return spareParam5;
	}

	public void setSpareParam5(String spareParam5) {
		this.spareParam5 = spareParam5;
	}

	@Override
	public String toString() {
		return "StaffPartJobVO [workerId=" + workerId + ", workerName=" + workerName + ", deptId=" + deptId + ", deptName=" + deptName + ", companyId=" + companyId + ", companyName=" + companyName
				+ ", positionId=" + positionId + ", positon=" + positon + ", property=" + property + ", jobStartTime=" + jobStartTime + ", jobEndTime=" + jobEndTime + ", jobTime=" + jobTime
				+ ", curState=" + curState + ", propertyName=" + propertyName + "]";
	}
	
}
