/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.orgcenter.commons;

import java.util.ArrayList;
import java.util.List;

public enum OrgStatus {
    INIT("\u521d\u59cb\u5316", -1),
    ENABLED("\u542f\u7528", 0),
    DISABLED("\u505c\u7528", 1);

    private String displayName;
    private int status;

    private OrgStatus(String displayName, int status) {
        this.displayName = displayName;
        this.status = status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static String getDisplayName(int status) {
        for (OrgStatus orgStatus : OrgStatus.values()) {
            if (orgStatus.getStatus() != status) continue;
            return orgStatus.getDisplayName();
        }
        return null;
    }

    public static int getStatus(String displayName) {
        for (OrgStatus orgStatus : OrgStatus.values()) {
            if (!orgStatus.getDisplayName().equals(displayName)) continue;
            return orgStatus.getStatus();
        }
        return -1;
    }

    public static boolean check(int status) {
        for (OrgStatus orgStatus : OrgStatus.values()) {
            if (orgStatus.getStatus() != status) continue;
            return true;
        }
        return false;
    }

    public static boolean check(List<Integer> statuses) {
        if (null == statuses || statuses.size() == 0) {
            return false;
        }
        for (int status : statuses) {
            if (OrgStatus.check(status)) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> getAllStatus() {
        ArrayList<Integer> list = new ArrayList<Integer>(3);
        for (OrgStatus orgStatus : OrgStatus.values()) {
            list.add(orgStatus.getStatus());
        }
        return list;
    }
}

