package com.yonyou.message.center.service;

import com.yonyou.uap.entity.content.EmailContent;
import com.yonyou.uap.entity.content.MessageContent;
import com.yonyou.uap.entity.content.SMSContent;
import com.yonyou.uap.entity.receiver.EmailReceiver;
import com.yonyou.uap.entity.receiver.MessageReceiver;
import com.yonyou.uap.entity.receiver.SMSReceiver;
import com.yonyou.uap.exception.MessageSendException;
import com.yonyou.uap.service.MessageSend;

public class MsgSendTest {
	public void sendEmail() throws MessageSendException {
		MessageReceiver msgReceivers = new EmailReceiver("taomaokun@foxmail.com");

		String content = "taomk , 您好!注册成功,欢迎使用教学管理系统!初始密码为：111111，请妥善保存!";

		MessageContent msgContent = new EmailContent("教学管理系统", content);

		new MessageSend(msgReceivers, msgContent).send();
	}

	public void sendSms() throws MessageSendException {
		MessageReceiver msgReceivers = new SMSReceiver("13699259112");

		String content = "taomk , 您好!注册成功,欢迎使用教学管理系统!初始密码为：111111，请妥善保存!";

		MessageContent msgContent = new SMSContent("iuap-saas", content, 0);

		new MessageSend(msgReceivers, msgContent).send();
	}

	public static void main(String[] args) {
		try {
			new MsgSendTest().sendSms();
			System.out.println("End!");
		} catch (MessageSendException e) {
			e.printStackTrace();
		}
	}
}