package com.yonyou.message.center.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.message.center.entity.AutoSendMsgParameter;
import com.yonyou.message.center.service.AutoSendMsgService;
import com.yonyou.message.center.service.SendType;
import com.yyjz.icop.mq.common.MqMessage;
import com.yyjz.icop.mq.sender.MsgSender;
import com.yyjz.icop.permission.role.service.UserRelationRoleService;
import com.yyjz.icop.share.api.bo.MsgTplMsgVO;
import com.yyjz.icop.share.api.service.MsgTplAPIService;
import com.yyjz.icop.usercenter.service.IUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Created by cdr_c on 2017/2/20.
 */
@Service("autoSendMsgService")
public class AutoSendMsgServiceImpl implements AutoSendMsgService {
    private static Logger logger = LoggerFactory.getLogger(AutoSendMsgServiceImpl.class);
    private static final String message_queue_name = "icop-message-queue-auto";

    @Autowired
    private MsgSender msgSender;
    @Autowired
    private MsgTplAPIService msgTplAPIService;
    @Autowired
    private IUserService userService;
    @Autowired
    private UserRelationRoleService userRelationRoleService;


    @Override
    public String pushMessage(AutoSendMsgParameter msgParameter) {
    	logger.debug("msgParameter: {}", JSONObject.toJSONString(msgParameter));
    	
    	String orgIds;
    	String roleIds;
    	String userIds = null;
        try {
            if (msgParameter.getSendType().equals(SendType.COMPANY_ROLE)) {
                orgIds = msgParameter.getCompanyId();
                roleIds = msgParameter.getRoleIds();
            } else {
                String msgCode = msgParameter.getMsgCode();
                String msgTplCode = msgParameter.getMsgTplCode();
                String companyId = msgParameter.getCompanyId();
                MsgTplMsgVO msgVO = msgTplAPIService.getMsgByCode(msgTplCode, msgCode);
                if (msgVO == null) {
                    return "{\"success\":false}";
                }
                logger.debug("msgVO: {}", JSONObject.toJSONString(msgVO));
                orgIds = StringUtils.isEmpty(companyId) ? msgVO.getDef1() : companyId;
                roleIds = msgVO.getDef2();
                userIds = msgVO.getDef3();
            }
            
            if (StringUtils.isEmpty(userIds)) {
                Set<String> orgUserIdList = new HashSet<>();
                Set<String> roleUserIdList = new HashSet<>();
                if (!StringUtils.isEmpty(orgIds)) {
                    String orgUserIds = this.getUserIdsByOrgIds(orgIds);
                    if (!StringUtils.isEmpty(orgUserIds)) {
                        orgUserIdList = new HashSet<>(Arrays.asList(orgUserIds.split(",")));
                    }
                }
                if (!StringUtils.isEmpty(roleIds)) {
                    String roleUserIds = this.getUserIdsByRoleIds(roleIds);
                    if (!StringUtils.isEmpty(roleUserIds)) {
                        roleUserIdList = new HashSet<>(Arrays.asList(roleUserIds.split(",")));
                    }
                }
                roleUserIdList.retainAll(orgUserIdList);
                
                userIds = StringUtils.collectionToCommaDelimitedString(roleUserIdList);
                
                if (StringUtils.isEmpty(userIds) && (roleUserIdList.size() > 0 || orgUserIdList.size() > 0)) {
                    logger.error("用户id为空：组织和角色下人员去交集，用户为空");
                    return "{\"success\":false,\"msg\":\"用户id为空：组织和角色下人员取交集，用户为空\"}";
                }
            }
            
            logger.debug("userIds: {}", userIds);

            if (StringUtils.isEmpty(userIds)) {
                logger.error("用户id为空：");
                return "{\"success\":false,\"msg\":\"用户id为空\"}";
            }
            
            msgParameter.setRecevier(StringUtils.commaDelimitedListToStringArray(userIds));

            MqMessage mqMessage = new MqMessage();
            mqMessage.setBody(msgParameter);
            msgSender.sendMessage(mqMessage, message_queue_name);
        } catch (Exception e) { 
            logger.error("消息推送失败：", e);
            return "{\"success\":false,\"msg\":\""+e.getMessage()+"\"}";
        }

        return "{\"success\":true,\"data\":\""+userIds+"\"}";
    }

    /**
     * 接收组织id（多个以逗号隔开），返回用户id（多个以逗号隔开）
     *
     * @param orgIds 组织id
     * @return 用户id
     */
    private String getUserIdsByOrgIds(String orgIds) {
        if (StringUtils.isEmpty(orgIds)) {
            return null;
        }

        List<String> userIds = userService.findByCompanyId(
                Arrays.asList(StringUtils.commaDelimitedListToStringArray(orgIds)));
        logger.debug("query userIds by orgIds: {}", userIds);

        return StringUtils.arrayToCommaDelimitedString(userIds.toArray());
    }

    /**
     * 接收角色id（多个以逗号隔开），返回用户id（多个以逗号隔开）
     *
     * @param roleIds 角色id
     * @return 用户id
     */
    private String getUserIdsByRoleIds(String roleIds) {
        if (StringUtils.isEmpty(roleIds)) {
            return null;
        }

        List<String> userIds = userRelationRoleService.findPowerRoleIds(
                Arrays.asList(StringUtils.commaDelimitedListToStringArray(roleIds)));
        logger.debug("query userIds by roleIds: {}", userIds);

        return StringUtils.arrayToCommaDelimitedString(userIds.toArray());
    }
}
