package com.yonyou.message.center.service.impl;

import com.yonyou.iuap.tenant.sdk.UserCenter;
import com.yonyou.uap.msg.persistence.entity.MsgUserEntity;
import com.yonyou.uap.msg.persistence.service.IMsgUserQryService;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class UserCenterQryServiceImpl implements IMsgUserQryService {
	@SuppressWarnings("deprecation")
	public MsgUserEntity queryUserInfoById(String id) {
		String userString = UserCenter.getUserById(id);
		JSONObject obj = JSONObject.fromObject(userString);
		String user = obj.getString("user");
		JSONObject userObj = JSONObject.fromObject(user);
		if (user.equals("{}")) {
			return null;
		}
		MsgUserEntity userEntity = new MsgUserEntity();
		String userId = userObj.getString("userId");
		String userCode = userObj.getString("userCode");
		String userName = userObj.getString("userName");
		String userEmail = userObj.getString("userEmail");
		String userMobile = userObj.getString("userMobile");
		String tenantId = userObj.getString("tenantId");
		userEntity.setId(userId);
		if (StringUtils.isNotBlank(userCode)) {
			userEntity.setCode(userCode);
		}

		if (StringUtils.isNotBlank(userEmail)) {
			userEntity.setEmail(userEmail);
		}

		if (StringUtils.isNotBlank(userMobile)) {
			userEntity.setPhone(userMobile);
		}
		if (StringUtils.isNotBlank(userName)) {
			userEntity.setName(userName);
		}
		if (StringUtils.isNotBlank(tenantId)) {
			userEntity.setTenant_id(tenantId);
		}
		return userEntity;
	}

	@SuppressWarnings("deprecation")
	public List<MsgUserEntity> getUsersByIds(String[] ids) {
		String usersString = UserCenter.getUserByPks(ids);
		JSONObject obj = JSONObject.fromObject(usersString);
		String users = obj.getString("users");
		JSONArray jsonArr = JSONArray.fromObject(users);
		List<MsgUserEntity> msgUserList = new ArrayList<MsgUserEntity>();
		if (jsonArr.size() > 0) {
			for (int i = 0; i < jsonArr.size(); i++) {
				MsgUserEntity user = new MsgUserEntity();
				JSONObject userObj = jsonArr.getJSONObject(i);
				String userId = userObj.getString("userId");
				String userCode = userObj.getString("userCode");
				String userName = userObj.getString("userName");
				String userEmail = userObj.getString("userEmail");
				String userMobile = userObj.getString("userMobile");
				String tenantId = userObj.getString("tenantId");
				user.setId(userId);
				if (StringUtils.isNotBlank(userCode)) {
					user.setCode(userCode);
				}

				if (StringUtils.isNotBlank(userEmail)) {
					user.setEmail(userEmail);
				}
				if (StringUtils.isNotBlank(userMobile)) {
					user.setPhone(userMobile);
				}
				if (StringUtils.isNotBlank(userName)) {
					user.setName(userName);
				}
				if (StringUtils.isNotBlank(tenantId)) {
					user.setTenant_id(tenantId);
				}

				msgUserList.add(user);
			}
		}
		return msgUserList;
	}
}