package com.yonyou.sms.action;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
 
import org.springside.modules.nosql.redis.JedisTemplate;

import com.google.gson.Gson;
import com.yyjz.icop.base.response.ObjectResponse;
import com.yonyou.sms.model.content.SMSContent;
import com.yonyou.sms.model.receiver.SMSReceiver;
import com.yonyou.sms.util.MessageContent;
import com.yonyou.sms.util.MessageResponse;
import com.yonyou.sms.util.MessageSend;
import com.yonyou.sms.util.ProduceNumber;
import com.yonyou.sms.util.Validate;

/**
 * 短信验证
 * 
 * @author guominga
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping({ "/sms" })
public class SmsController {
	
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
    private JedisTemplate jedis;
	
	/**
	 * 检查验证码是否正确
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = { "checkMessage" }, method = { RequestMethod.POST })
	@ResponseBody
	public Object CheckMessage(@RequestBody(required = false) String param) {
		logger.debug("传输param：{}", param);
		
		ObjectResponse<String> objectResponse = new ObjectResponse<String>();
		try{
			Gson gson = new Gson();
			Map<String, String> paramMap = gson.fromJson(param, Map.class);
			String phoneNum = paramMap.get("phoneNum");
			String vali = paramMap.get("validate");
			String ran = this.jedis.get(phoneNum);
			if (StringUtils.isEmpty(ran)) {
				objectResponse.setCode(false);
				objectResponse.setMsg("手机验证码已经过期，请重新获取短息验证码！");
				return objectResponse;
			}
			if (vali.equals(ran)){
				objectResponse.setCode(true);
				objectResponse.setMsg("短息验证成功!");
			} else {
				objectResponse.setCode(false);
				objectResponse.setMsg("手机验证码输入错误，请确认之后重新输入！");
			}
		}catch(Exception e){
			e.printStackTrace();
			objectResponse.setCode(false);
			objectResponse.setMsg("系统异常，请检查传参是否合法 , msg："+e.getMessage());
		}
		return objectResponse;
	}

	/**
	 * 发送短消息
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = { "sendMessage" }, method = { RequestMethod.GET })
	@ResponseBody
	public Object sendMessage(@RequestParam(required = false) String param,HttpServletRequest request) {
		logger.debug("传输param：{}", param);
		
		ObjectResponse<String> objectResponse = new ObjectResponse<String>();
		
		try {
			Date date = new Date();
			Gson gson = new Gson();
			Map<String, String> paramMap = gson.fromJson(param, Map.class);
			String phoneNum = paramMap.get("phone");
			String clientIp = getLocalIp(request);
			if (!validateIp(clientIp, date).booleanValue()) {
				objectResponse.setCode(false);
				objectResponse.setMsg("error");
				return objectResponse;
			}
	
			String timeStr = this.jedis.get(phoneNum + "time");
			if (StringUtils.isNotBlank(timeStr)) {
				long ltime = Long.parseLong(timeStr);
				if ((date.getTime() - ltime) / 1000L < 60L) {
					this.jedis.setex(phoneNum + "time", date.getTime() + "", 600);
					objectResponse.setCode(false);
					objectResponse.setMsg("一分钟内不能重复发送验证码");
					return objectResponse;
				}
			}
	
			if (Validate.isMobile(phoneNum)) {
				SMSReceiver mr = new SMSReceiver(phoneNum);
				String rand = ProduceNumber.produce();
				String msg = " 验证码:" + rand + "，您正在进行用友云服务用户注册，（用友客服绝对不会索要该验证码，切勿告诉他人），感谢您的支持!";
				MessageContent mc = new SMSContent("短信验证", msg, 0);
				try {
					List<MessageResponse> snds = new MessageSend(mr, mc).send();
					this.jedis.setex(phoneNum, rand, 300);
	
					this.jedis.setex(phoneNum + "time", date.getTime() + "", 600);
					
					objectResponse.setCode(true);
					objectResponse.setMsg(((MessageResponse) snds.get(0)).getResponseContent());
				} catch (Exception e) {
					objectResponse.setCode(false);
					objectResponse.setMsg("短信发送失败");
					this.logger.error("短信发送失败", e);
				}
			} else {
				objectResponse.setCode(false);
				objectResponse.setMsg("您输入的手机号不合法");
			}
		}catch(Exception e){
			e.printStackTrace();
			
			objectResponse.setCode(false);
			objectResponse.setMsg("系统异常，请检查传参是否合法，msg:" + e.getMessage());
		}
		return objectResponse;
	}

	public String getLocalIp(HttpServletRequest request) {
		String remoteAddr = request.getRemoteAddr();
		String forwarded = request.getHeader("X-Forwarded-For");
		String realIp = request.getHeader("X-Real-IP");

		String ip = null;
		if (realIp == null) {
			if (forwarded == null)
				ip = remoteAddr;
			else {
				ip = remoteAddr + "/" + forwarded.split(",")[0];
			}
		} else if (realIp.equals(forwarded)) {
			ip = realIp;
		} else {
			if (forwarded != null) {
				forwarded = forwarded.split(",")[0];
			}
			ip = realIp + "/" + forwarded;
		}

		return ip;
	}

	public Boolean validateIp(String ip, Date date) {
		String times = this.jedis.get(ip);
		if (StringUtils.isBlank(times)) {
			this.jedis.setex(ip + "date", date.getTime() + "", 60);
			times = "1";
			this.jedis.setex(ip, times, 60);
		} else {
			this.jedis.setex(ip, Integer.parseInt(times) + 1 + "", 60);
			times = Integer.parseInt(times) + 1 + "";
		}
		boolean flag = true;
		Long seconds = Long.valueOf((date.getTime() - Long.parseLong(this.jedis.get(ip + "date"))) / 1000L);
		int t = Integer.parseInt(times);
		if ((seconds.longValue() < 60L) && (t > 5)) {
			flag = false;
		}
		return Boolean.valueOf(flag);
	}

}
