package com.yonyou.sms.service.impl;

import java.util.Iterator;
import java.util.List;

import org.dom4j.Element;

import com.yonyou.sms.model.content.SMSContent;
import com.yonyou.sms.util.HttpRequest;
import com.yonyou.sms.util.MessageResponse;
import com.yonyou.sms.util.SimpleParseXML;

public class SMSSend {
	
	private static String corpId = "";

	private static String secretKey = "";

	private static String url = "";
	private static final String SMS_SEND_TYPE = "sms";

	public static SMSSend initialization() {
		parseSMSConfig();

		return new SMSSend();
	}

	public MessageResponse send(String mobileNum, SMSContent content) {
		StringBuffer paramSB = new StringBuffer("");
		paramSB.append("corpId=").append(corpId);
		paramSB.append("&secretKey=").append(secretKey);

		if ((null != content.getTitle()) && (content.getTitle().trim().length() > 0)) {
			paramSB.append("&title=").append(content.getTitle());
		}
		paramSB.append("&content=").append(content.getMSGContent());
		if (content.getSendtime() != 0) {
			paramSB.append("&sendtime=").append(content.getSendtime());
		}
		paramSB.append("&mobile=").append(mobileNum);

		System.out.println("向" + mobileNum + "发送短信...");
		System.out.println("Param:" + paramSB.toString());

		String smsResponse = HttpRequest.sendPost(url, paramSB.toString());

		MessageResponse response = new SimpleParseXML().getMessageResponseByCode(SMS_SEND_TYPE, smsResponse);

		if ("1000".equals(response.getResponseStatusCode()))
			System.out.println("短信发送成功!");
		else {
			System.out.println("短信发送失败! 原因：" + response.getResponseContent());
		}

		return response;
	}

	@SuppressWarnings("rawtypes")
	private static void parseSMSConfig() {
		List<Element> smsElementList = new SimpleParseXML().getMSConfig(SMS_SEND_TYPE);

		if ((null != smsElementList) && (smsElementList.size() > 0)) {
			Element smsElement = (Element) smsElementList.get(0);

			Iterator iterator = smsElement.elementIterator();
			while (iterator.hasNext()) {
				Element element = (Element) iterator.next();

				if ("corpId".equals(element.getName())) {
					corpId = element.getTextTrim();
				} else if ("secretKey".equals(element.getName())) {
					secretKey = element.getTextTrim();
				} else if ("url".equals(element.getName()))
					url = element.getTextTrim();
			}
		} else {
			System.err.println("缺少<sms>配置");
		}
	}

	public static void main(String[] args) {
		String telNumber = "15222476920";

		String msgTitle = "This is a message title~";
		String msgContent = "This is a message content~";
		int sendTime = 0;
		SMSContent content = new SMSContent(msgTitle, msgContent, sendTime);

		System.out.println(initialization().send(telNumber, content));
	}
}