package com.yonyou.sms.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpRequest {
	private static final Log logger = LogFactory.getFactory().getInstance(HttpRequest.class);

	public static String sendGet(String url, String param) {
		String result = "";
		BufferedReader in = null;
		try {
			String urlNameString = url + "?" + param;
			URL realUrl = new URL(urlNameString);

			URLConnection connection = realUrl.openConnection();

			connection.setRequestProperty("accept", "*/*");
			connection.setRequestProperty("connection", "Keep-Alive");
			connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");

			connection.connect();

			Map<String, List<String>> map = connection.getHeaderFields();

			for (String key : map.keySet()) {
				System.out.println(key + "--->" + map.get(key));
			}

			in = new BufferedReader(new InputStreamReader(connection.getInputStream()));

			while (in.readLine() != null)
				result = result + in.readLine();
		} catch (Exception e) {
			logger.error(e);
		} finally {
			try {
				if (in != null)
					in.close();
			} catch (Exception e2) {
				logger.error(e2);
			}
		}
		return result;
	}

	public static String sendPost(String url, String param) {
		PrintWriter out = null;
		BufferedReader in = null;
		String result = "";
		try {
			URL realUrl = new URL(url);

			HttpURLConnection conn = (HttpURLConnection) realUrl.openConnection();

			conn.setRequestMethod("POST");
			conn.setRequestProperty("accept", "*/*");
			conn.setRequestProperty("connection", "Keep-Alive");
			conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");

			conn.setUseCaches(false);
			conn.setDoOutput(true);
			conn.setDoInput(true);

			out = new PrintWriter(conn.getOutputStream());

			out.print(param);

			out.flush();

			in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			String line;
			while ((line = in.readLine()) != null)
				result = result + line;
		} catch (Exception e) {
			logger.error(e);
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null)
					in.close();
			} catch (IOException ex) {
				logger.error(ex);
			}
		}
		return result;
	}

	public static void main(String[] args) {
		String upushURL = "http://upush.yyuap.com/remote/req.do";
		String upushParam = "type=message_send&userName=taomkpush&userKey=0916c93953ef22bf9751c23f2d97f2&appId=223&subject=标题测试&content=推送内容测试&receiveDevice=11111111";

		String upushResponse = sendPost(upushURL, upushParam);
		System.out.println(upushResponse);
	}
}