package com.yonyou.sms.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


@SuppressWarnings({ "unchecked", "rawtypes" })
public class SimpleParseXML {
	private static Logger logger = LoggerFactory.getLogger(SimpleParseXML.class);

	public List<Element> getMSConfig(String elementName) {
		String configFilePath = "msconfig.xml";
		Element root = getDocument(configFilePath).getRootElement();
		return root.elements(elementName);
	}

	public Map<String, String> getErrorCodeDescription(String pushType) {
		Map<String, String> returnMap = new HashMap<String, String>();

		String errorFilePath = "ReturnCodeDescription.xml";

		Element root = getDocument(errorFilePath).getRootElement();

		Element pushTypeNode = (Element) root.elements(pushType).get(0);

		Iterator iterator = pushTypeNode.elementIterator();
		while (iterator.hasNext()) {
			Element descriptionElement = (Element) iterator.next();
			returnMap.put(descriptionElement.attributeValue("code"), descriptionElement.attributeValue("content"));
		}

		return returnMap;
	}

	public MessageResponse getMessageResponseByCode(String pushType, String responseJSON) {
		String code = JsonHelper.getAttributeValue(responseJSON, "code");

		Map<String, String> returnMap = new SimpleParseXML().getErrorCodeDescription(pushType);
		String content = (String) returnMap.get(code);

		MessageResponse response = new MessageResponse(code, content);

		return response;
	}

	private Document getDocument(String filePath) {
		SAXReader reader = new SAXReader();
		Document doc = null;
		try {
			InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
			doc = reader.read(in);
		} catch (DocumentException e) {
			logger.error("指定文件路径：" + filePath + "不存在！", e);
		}

		return doc;
	}

	public static void main(String[] args) {
		Map<String, String> returnMap = new SimpleParseXML().getErrorCodeDescription("messagepush");

		System.out.println(returnMap);
	}
}