package com.yonyou.uap.message.controller;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.message.dao.MsgChannelMapper;
import com.yonyou.uap.message.entity.MsgChannel;
import com.yonyou.uap.message.service.IMessageChannel;
import com.yonyou.uap.util.SimpleParseXML;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@SuppressWarnings("unchecked")
@Controller
@RequestMapping({ "/message/" })
public class MessageChannelController {

	@Autowired
	private IMessageChannel massageChannel;

	@Autowired
	private MsgChannelMapper msgChannelMapper;

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = { "/data/{id}" })
	@ResponseBody
	public Object queryMsgChannel(@PathVariable("id") String id) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		if (StringUtils.isEmpty(id)) {
			returnMap.put("msg", "消息通道Id为空，无法加载消息通道内容");
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}

		MsgChannel channel = this.massageChannel.queryMsgChannelById(id);

		returnMap.put("data", channel);
		returnMap.put("msg", "查询成功!");
		returnMap.put("status", Integer.valueOf(1));
		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"updateMsgChannel" })
	@ResponseBody
	public Map<String, Object> updateMsgChannel(HttpServletRequest request, HttpServletResponse response) throws JsonParseException, JsonMappingException, IOException {
		Map<String, Object> returnMap = new HashMap<String, Object>();

		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		Map<String, Object> dataMap = (Map<String, Object>) mapper.readValue(jsonString, HashMap.class);
		String id = (String) dataMap.get("id");
		Map<String, Object> configMap = (Map<String, Object>) dataMap.get("configinfo");
		JSONObject jsonObj = JSONObject.fromObject(configMap);
		String configJson = jsonObj.toString();
		MsgChannel channel = this.msgChannelMapper.selectByPrimaryKey(id);
		if (channel == null) {
			returnMap.put("msg", "数据已被删除");
			returnMap.put("status", Integer.valueOf(0));
		} else {
			channel.setConfiginfo(configJson);
			this.massageChannel.update(channel);
			returnMap.put("msg", "修改成功");
			returnMap.put("status", Integer.valueOf(1));
		}
		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = {"/queryAllMsgChannel" })
	@ResponseBody
	public Object queryAllMsgChannel() {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		List<MsgChannel> channelList = this.massageChannel.queryAllMsgChannel();
		JSONObject keyNameObj = SimpleParseXML.getInstance().getChannelName();

		returnMap.put("data", channelList);
		returnMap.put("nameData", keyNameObj);

		returnMap.put("msg", "查询成功!");
		returnMap.put("status", Integer.valueOf(1));
		return returnMap;
	}
}