package com.yonyou.uap.message.persistence.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yonyou.message.center.entity.PushMsgParameter;
import com.yonyou.message.center.entity.UserMessageEntity;
import com.yonyou.message.center.entity.UserRecMsgEntity;
import com.yonyou.message.center.service.IMessageManageService;
import com.yonyou.message.center.service.PushMsgService;
import com.yonyou.uap.message.utils.CommonUtils;
import com.yonyou.uap.msg.persistence.entity.MessageEntity;
import com.yonyou.uap.msg.persistence.entity.MsgReceiverEntity;
import com.yonyou.uap.msg.persistence.entity.MsgTypeEntity;
import com.yonyou.uap.msg.persistence.entity.MsgUserEntity;
import com.yonyou.uap.msg.persistence.sdk.MessageServiceSdk;
import com.yonyou.uap.msg.persistence.service.IMessageService;
import com.yonyou.uap.msg.persistence.service.IMsgReceiverService;
import com.yonyou.uap.msg.persistence.service.IMsgTypeService;
import com.yonyou.uap.msg.persistence.service.IUserInfoService;
import com.yyjz.icop.usercenter.service.IUserService;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

@SuppressWarnings("unchecked")
@Controller
@RequestMapping({ "/message" })
public class MsgPersistenceController {

	@Autowired
	private IMessageService msgService;

	@Autowired
	private IMsgReceiverService receiverService;

	@Autowired
	private IMsgTypeService msgTypeService;

	@Autowired
	private IUserInfoService userInfoService;
	@Autowired
	private IMessageManageService messageManageService;
	@Autowired
	private IUserService userService;
	@Autowired
	private MessageServiceSdk messageServiceSdk;
	@Autowired
	private PushMsgService pushMsgService;
	private Logger logger = LoggerFactory.getLogger(MsgPersistenceController.class);

	@ResponseBody
	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = { "/getMessage" })
	public Map<String, Object> getMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		Map<String, Object> dataMap = null;
		try {
			dataMap = (Map<String, Object>) mapper.readValue(jsonString, HashMap.class);
		} catch (IOException e) {
			this.logger.error(e.getMessage(), e);
			returnMap.put("data", "");
			returnMap.put("msg", "消息查询出错");
			returnMap.put("status", "0");
			return returnMap;
		}

		Map<String,Object> returnDataMap = new HashMap<String,Object>();

		String receiver = getReceiver(dataMap);

		List<MsgTypeEntity> msgTypeList = this.msgTypeService.queryAllMsgType();
		List<Map<String,Object>> list = new ArrayList<Map<String,Object>>();
		List<Map<String,Object>> msgTypeNumMapList = this.msgService.queryMsgTypeNumber(receiver);
		for (MsgTypeEntity msgType : msgTypeList) {
			Map<String,Object> msgTypeMap = new HashMap<String,Object>();
			msgTypeMap.put("typecode", msgType.getTypecode());
			msgTypeMap.put("typename", msgType.getTypename());
			int msgNum = 0;
			for (Map<String,Object> map : msgTypeNumMapList) {
				if ((map.get("msgtype") != null) && (msgType.getTypecode().equals(map.get("msgtype")))) {
					msgNum = ((Number) map.get("count")).intValue();
				}
			}
			msgTypeMap.put("num", Integer.valueOf(msgNum));
			list.add(msgTypeMap);
		}
		returnDataMap.put("msgtype", list);
		Map<String, Object> searchMap = buildSearchMap(dataMap, request);
		List<MessageEntity> msgList = getMessageList(searchMap);

		transMessageList(msgList);
		returnDataMap.put("message", msgList);

		returnMap.put("data", returnDataMap);
		returnMap.put("status", Integer.valueOf(1));
		returnMap.put("msg", "消息查询成功");

		return returnMap;
	}

	private String getReceiver(Map<String, Object> dataMap) {
		String receiver = InvocationInfoProxy.getUserid();
		if (org.springframework.util.StringUtils.isEmpty(receiver)) {
			receiver = (String) dataMap.get("receiver");
		}
		return receiver;
	}

	private String getTenantId() {
//		return "ppo2wx9x";
		return InvocationInfoProxy.getTenantid();
	}
	
	private String getUserId() {
//		return "e996cb85-915e-46c1-a0a5-d8a7a2c68fdd";
//		return "e996cb85-915e-46c1-a0a5-d8a7a2c68fdd";	//wang1
		return InvocationInfoProxy.getUserid();
	}

	@ResponseBody
	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"/getMessageforMainView" })
	public Map<String, Object> getMessageInfo(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
        Map<String, Object> dataMap = null;

        try {
			dataMap = getRequestData(request);

		} catch (Exception e) {
			this.logger.error(e.getMessage(), e);
			returnMap.put("data", "");
			returnMap.put("msg", "消息查询出错");
			returnMap.put("status", "0");
			return returnMap;
		}

		Map<String, Object> returnDataMap = new HashMap<String, Object>();

		Map<String, Object> searchMap = buildSearchMap(dataMap, request);

		List<MsgTypeEntity> msgTypeList = this.msgTypeService.queryAllMsgType();

		List<MessageEntity> msgList = getMessageList(searchMap);

		transMessageList(msgList);

		List<Map<String,Object>> msgNumList = new ArrayList<Map<String,Object>>();
		List<String> statusList = new ArrayList<String>();
		statusList.add("read");
		statusList.add("unread");
		for (String statuskey : statusList) {
			Map<String,Object> msgNumMap = new HashMap<String,Object>();
			int readNum = 0;
			if (statuskey.equals("read")) {
				searchMap.put("status", "1");
				msgNumMap.put("status", "read");
				readNum = this.msgService.getMessageNum(searchMap);
			} else if (statuskey.equals("unread")) {
				searchMap.put("status", "0");
				msgNumMap.put("status", "unread");
				readNum = this.msgService.getUnReadMessageNum(searchMap);
			}
			msgNumMap.put("num", Integer.valueOf(readNum));
			msgNumList.add(msgNumMap);
		}
		String tenantid = getTenantId();
		String receiver = getReceiver(dataMap);

		int count = getUnreadMsgNums(receiver, tenantid);
		returnDataMap.put("totalUnreadNum", Integer.valueOf(count));
		returnDataMap.put("msgtype", msgTypeList);
		returnDataMap.put("message", msgList);
		returnDataMap.put("msgnum", msgNumList);
		returnDataMap.put("current", String.valueOf(dataMap.get("pagenum")));
		returnMap.put("data", returnDataMap);
		returnMap.put("status", Integer.valueOf(1));
		returnMap.put("msg", "消息查询成功");

		return returnMap;
	}

	private void transMessageList(List<MessageEntity> msgList) {
		List<String> userIdList = new ArrayList<String>();
		for (Iterator<MessageEntity> localIterator1 = msgList.iterator(); localIterator1.hasNext();) {
			MessageEntity entity = (MessageEntity) localIterator1.next();
			String userId = entity.getSender();
			if (org.apache.commons.lang.StringUtils.isNotBlank(userId))
				userIdList.add(userId);
		}
		List<MsgUserEntity> userList = this.userInfoService.getUsersByIds((String[]) userIdList.toArray(new String[0]));
		for (MessageEntity entity : msgList) {
			String userId = entity.getSender();
			String userName = userId;
			if (!org.springframework.util.StringUtils.isEmpty(userId)) {
				for (MsgUserEntity user : userList) {
					if (user.getId().equals(userId)) {
						userName = user.getName();
						break;
					}
				}
				entity.setSender(userName);
			}
		}
	}

	private Map<String, Object> buildSearchMap(Map<String, Object> dataMap, HttpServletRequest request) {
		String currentPageStr = String.valueOf(dataMap.get("pagenum"));
		String pageSizeStr = String.valueOf(dataMap.get("pagesize"));
		String msgtype = (String) dataMap.get("msgtype");
		String status = (String) dataMap.get("status");
		String receiver = getReceiver(dataMap);
		String startTime = (String) dataMap.get("starttime");
		String endTime = (String) dataMap.get("endtime");
		String search = (String) dataMap.get("search");
		int currentPage = 0;
		int pageSize = 0;
		Map<String,Object> searchMap = new HashMap<String,Object>();
		if (org.springframework.util.StringUtils.isEmpty(currentPageStr))
			currentPage = 1;
		else {
			currentPage = Integer.valueOf(currentPageStr).intValue();
		}
		if (org.springframework.util.StringUtils.isEmpty(pageSizeStr))
			pageSize = 10;
		else {
			pageSize = Integer.valueOf(pageSizeStr).intValue();
		}

		if ((!org.springframework.util.StringUtils.isEmpty(msgtype)) && (!msgtype.equals("all"))) {
			searchMap.put("msgtype", msgtype);
		}
		int startIndex = (currentPage - 1) * pageSize;
		searchMap.put("startIndex", Integer.valueOf(startIndex));
		searchMap.put("pageSize", Integer.valueOf(pageSize));

		searchMap.put("receiver", receiver);
		if (!org.springframework.util.StringUtils.isEmpty(status)) {
			searchMap.put("status", status);
		}
		if (!org.springframework.util.StringUtils.isEmpty(startTime)) {
			searchMap.put("starttime", startTime);
		}
		if (!org.springframework.util.StringUtils.isEmpty(endTime)) {
			searchMap.put("endtime", endTime);
		}
		if (!org.springframework.util.StringUtils.isEmpty(search)) {
			String searchContent = "%" + search + "%";
			searchMap.put("search", searchContent);
		}
		String tenantId = getTenantId();
		if (org.springframework.util.StringUtils.isEmpty(tenantId))
			searchMap.put("tenantid", dataMap.get("tenantid"));
		else {
			searchMap.put("tenantid", tenantId);
		}
		return searchMap;
	}

	private List<MessageEntity> getMessageList(Map<String, Object> searchMap) {
		List<MessageEntity> msgList = null;
		if ((!org.springframework.util.StringUtils.isEmpty(searchMap.get("status")))
				&& (searchMap.get("status").equals("0")))
			msgList = this.msgService.getUnReadMessage(searchMap);
		else {
			msgList = this.msgService.getMessage(searchMap);
		}
		return msgList;
	}

	@ResponseBody
	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"/updatestatus" })
	public Map<String, Object> updatestatus(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();

		Map<String, Object> dataMap;
		try {
			dataMap = getRequestData(request);
			
			String msgid = (String) dataMap.get("id");
			String status = (String) dataMap.get("status");
			String receiver = null;
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (Cookie cookie : cookies) {
					if (cookie.getName().equals("userId")) {
						receiver = cookie.getValue();
					}
				}
			}

			if (org.springframework.util.StringUtils.isEmpty(receiver)) {
				receiver = InvocationInfoProxy.getUserid();
			}
			MsgReceiverEntity receiverEntity = this.receiverService.queryReceiverByMsgIdAndReceiver(msgid, receiver);
			if (org.springframework.util.StringUtils.isEmpty(receiverEntity)) {
				returnMap.put("msg", "数据已被删除，不存在");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}

			if (!org.springframework.util.StringUtils.isEmpty(status)) {
				receiverEntity.setStatus(status);
			}

			this.messageServiceSdk.updateStatus(receiverEntity);
			returnMap.put("msg", "消息状态回写成功");
			returnMap.put("status", Integer.valueOf(1));
			return returnMap;
		} catch (IOException e) {
			this.logger.error(e.getMessage(), e);
			returnMap.put("msg", "修改数据出错");
			returnMap.put("status", Integer.valueOf(0));
		}
		return returnMap;
	}

	private Map<String, Object> getRequestData(HttpServletRequest request) throws IOException {
		Map<String, Object> dataMap;
		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();

		if (StringUtils.isBlank(jsonString)) {
            ServletInputStream inputStream = request.getInputStream();

            jsonString = IOUtils.toString(inputStream);

            dataMap = (Map<String, Object>) mapper.readValue(jsonString, HashMap.class);
            dataMap = (Map<String, Object>) dataMap.get("data");
        } else {
            dataMap = (Map<String, Object>) mapper.readValue(jsonString, HashMap.class);
        }
		return dataMap;
	}

	@ResponseBody
	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = { "/getUnReadMsg" })
	public Map<String, Object> getUnReadMsg(HttpServletRequest request, HttpServletResponse response) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		String receiver = request.getParameter("receiver");
		if (org.apache.commons.lang.StringUtils.isBlank(receiver)) {
			receiver = InvocationInfoProxy.getUserid();
		}
		if (org.apache.commons.lang.StringUtils.isBlank(receiver)) {
			returnMap.put("msg", "消息接受人不存在");
			returnMap.put("status", "0");
			return returnMap;
		}

		String tenantid = getTenantId();
		int count = getUnreadMsgNums(receiver, tenantid);
		returnMap.put("unReadNum", Integer.valueOf(count));
		returnMap.put("status", "1");
		return returnMap;
	}

	private int getUnreadMsgNums(String receiver, String tenantid) {
		int count = 0;
		List<String> receiverList = new ArrayList<String>();
		receiverList.add(receiver);

		Map<String,Object> searchMap = new HashMap<String,Object>();
		if (org.apache.commons.lang.StringUtils.isNotBlank(tenantid)) {
			searchMap.put("tenantid", tenantid);
		}
		searchMap.put("receiverList", receiverList);
		List<Map<String,Object>> unreadMsgNumMap = this.msgService.getUnReadMsgNumBatch(searchMap);
		if (null != unreadMsgNumMap) {
			for (Map<String,Object> msgNumMap : unreadMsgNumMap) {
				count = Integer.valueOf(String.valueOf(msgNumMap.get("count"))).intValue();
			}
		}
		return count;
	}
	
	@RequestMapping(value = "/allMsgs")
	@ResponseBody
	public Map<String, Object> getAllMsgs(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> dataMap = null;
		Map<String, Object> respMap = new HashMap<String, Object>();
		
		//参数处理
		try {
			dataMap = getRequestData(request);
			
			String queryType = String.valueOf(dataMap.get("type"));
			if("1".equals(queryType)) {
				return getAllSendMsgs(dataMap);
			} else if("2".equals(queryType)) {
				return getAlldelMsgsByProperties(dataMap);
			} else {
				return getAllRecMsgsByProperties(dataMap);
			}
			
		} catch (IOException e) {
			this.logger.error(e.getMessage(), e);
			respMap.put("data", "");
			respMap.put("msg", "消息查询出错");
			respMap.put("status", "0");
			return respMap;
		}
	}
	
	/**
	 * 查询所有满足条件的已发送的消息
	 * 
	 * @return
	 */
	public Map<String, Object> getAllSendMsgs(Map<String, Object> dataMap) {
		Map<String, Object> respMap = new HashMap<String, Object>();
        String tenantId = getTenantId();
        String userId = getUserId();
        
		try {
			//参数处理
			if(StringUtils.isNotBlank(tenantId)) {
				dataMap.put("tenantid", tenantId);
			}
			
			String pageSize = null != dataMap.get("pagesize") ? dataMap.get("pagesize").toString() : "10";
			String currentPage = null == dataMap.get("pagenum") ? "1" : dataMap.get("pagenum").toString();
			int startIndex = (Integer.valueOf(currentPage) - 1) * Integer.valueOf(pageSize);
//			String status = null == dataMap.get("status") ? "0" : dataMap.get("status").toString();
			dataMap.put("status", "0");
			dataMap.put("startIndex", startIndex);
			dataMap.put("pageSize", Integer.valueOf(pageSize));
			dataMap.put("sender", userId);
			
			//查询用户已发送的消息
			List<UserMessageEntity> userSendMsgsList = this.messageManageService.queryAllSendMsgs(dataMap);
			
			Integer totalDataNums = this.messageManageService.queryAllSendMsgsNum(dataMap);
			
 			List<Map<String,Object>> msgNumList = new ArrayList<Map<String,Object>>();
			Map<String, Object> numMap = new HashMap<String, Object>();
			numMap.put("num", totalDataNums != null ? totalDataNums : 0);
			msgNumList.add(new HashMap<String, Object>());
			msgNumList.add(numMap);
			msgNumList.add(new HashMap<String, Object>());
			
			//匹配对应的收件人
			getMsgReceiverInfo(userSendMsgsList);
			
			
			Map<String, Object> returnMap = new HashMap<String, Object>();
			//查询结果返回
			List<MsgTypeEntity> msgTypeList = this.msgTypeService.queryAllMsgType();
			respMap.put("msgtype", msgTypeList);
			respMap.put("current", currentPage);
			respMap.put("message", userSendMsgsList);
			respMap.put("status", Integer.valueOf(1));
			respMap.put("msgnum", msgNumList);
			
			returnMap.put("data", respMap);
			returnMap.put("status", Integer.valueOf(1));
			returnMap.put("msg", "消息查询成功");
			
			return returnMap;
			
		} catch (Exception e) {
			this.logger.error(e.getMessage(), e);
			respMap.put("data", "");
			respMap.put("msg", "消息查询出错");
			respMap.put("status", "0");
			return respMap;
		}
	}
	
	/**
	 * 查询所有满足条件的已删除的消息
	 * 
	 * @return
	 */
	public Map<String, Object> getAlldelMsgsByProperties(Map<String, Object> dataMap) {
		Map<String, Object> respMap = new HashMap<String, Object>();
		String tenantId = getTenantId();
		String uid = getUserId();
		
		try {
			if(StringUtils.isNotBlank(tenantId)) {
				dataMap.put("tenantid", tenantId);
			}
			
			String pageSize = null != dataMap.get("pagesize") ? dataMap.get("pagesize").toString() : "10";
			String currentPage = null == dataMap.get("pagenum") ? "1" : dataMap.get("pagenum").toString();
			int startIndex = (Integer.valueOf(currentPage) - 1) * Integer.valueOf(pageSize);
			dataMap.put("startIndex", startIndex);
			dataMap.put("pageSize", Integer.valueOf(pageSize));
			
			dataMap.put("receiver", uid);
			dataMap.put("sender", uid);
			dataMap.put("status2", new String[]{UserMessageEntity.MSG_STATUS_PREPDELETE});
			dataMap.put("status1", new String[]{UserMessageEntity.MSG_STATUS_NORMAL,
					UserMessageEntity.MSG_STATUS_PREPDELETE,UserMessageEntity.MSG_STATUS_DELETE});
			dataMap.put("recMsgDr", UserRecMsgEntity.HANDLE_STATUS_PREPDELETE);
			
			//查询用户已发送的消息
			List<UserMessageEntity> userSendMsgsList = this.messageManageService.queryAllDelMsgs(dataMap);
			
			//匹配对应的收件人
			getMsgReceiverInfo(userSendMsgsList);
			//匹配对应的发件人
			getMsgSenderInfo(userSendMsgsList);
			
			Integer totalDataNums = this.messageManageService.queryAllDelMsgsNum(dataMap);
			
			List<Map<String, Object>> msgNumList = new ArrayList<Map<String, Object>>();
			Map<String, Object> numMap = new HashMap<String, Object>();
			numMap.put("num", totalDataNums != null ? totalDataNums : 0);
			msgNumList.add(new HashMap<String, Object>());
			msgNumList.add(numMap);
			msgNumList.add(new HashMap<String, Object>());
			
			Map<String, Object> returnMap = new HashMap<String, Object>();
			//查询结果返回
			List<MsgTypeEntity> msgTypeList = this.msgTypeService.queryAllMsgType();
			respMap.put("msgtype", msgTypeList);
			respMap.put("current", currentPage);
			respMap.put("message", userSendMsgsList);
			respMap.put("status", Integer.valueOf(1));
			respMap.put("msgnum", msgNumList);
			
			returnMap.put("data", respMap);
			returnMap.put("status", Integer.valueOf(1));
			returnMap.put("msg", "消息查询成功");
			
			return returnMap;
		} catch (Exception e) {
			this.logger.error(e.getMessage(), e);
			respMap.put("data", "");
			respMap.put("msg", "消息查询出错");
			respMap.put("status", "0");
			return respMap;
		}
	}
	
	/**
	 * 填充消息收件人名称信息
	 * 
	 * @param  userSendMsgsList
	 */
	private void getMsgReceiverInfo(List<UserMessageEntity> userSendMsgsList) {
		List<String> uids = new ArrayList<String>();
	    //Map<msgId, msgReceiverIdArr>
	    Map<String, String[]> msgRecers = new HashMap<String, String[]>();
	    List<Map<String, String>> receiversList = new ArrayList<Map<String, String>>();
		
	    if(CollectionUtils.isNotEmpty(userSendMsgsList)) {
			for(UserMessageEntity ue : userSendMsgsList) {
				String[] uidArr = null;
				if(StringUtils.isBlank(ue.getReceiver())) {
					continue;
				}
				uidArr = ue.getReceiver().split(",");
				for(String uid : uidArr) {
					if(!uids.contains(uid)) {
						uids.add(uid);
					}
				}
				msgRecers.put(ue.getId(), uidArr);
			}
			Map<String,UserBaseVO> usersMap = userService.getAllUserMapByUid(uids);
			 
			StringBuffer recNames = null;
			for(UserMessageEntity ue : userSendMsgsList) {
				recNames = new StringBuffer();
				String[] uidArr = msgRecers.get(ue.getId());
				if(StringUtils.isBlank(ue.getReceiver())) {
					continue;
				}
				uidArr = ue.getReceiver().split(",");
				for(String uid : uidArr) {
					Map<String, String> recer = new HashMap<String, String>();
					UserBaseVO vo = usersMap.get(uid);
					if(null == vo || StringUtils.isBlank(vo.getUserName())) {
						continue;
					}
					recNames.append(vo.getUserName()).append(",");
					recer.put("id", vo.getUserId());
					recer.put("name", vo.getUserName());
					receiversList.add(recer);
				}
				if(StringUtils.isNotBlank(recNames.toString())) {
					ue.setReceverName(recNames.toString().substring(0, recNames.lastIndexOf(",")));
					ue.setReceivers(receiversList);
				}
			}
		}
	}
	/**
	 * 填充消息发件人名称信息
	 * 
	 * @param  userSendMsgsList
	 */
	private void getMsgSenderInfo(List<UserMessageEntity> userSendMsgsList) {
		List<String> uids = new ArrayList<String>();
		
		if(CollectionUtils.isNotEmpty(userSendMsgsList)) {
			for(UserMessageEntity ue : userSendMsgsList) {
					if(!uids.contains(ue.getSender()) && StringUtils.isNotBlank(ue.getSender())) {
						uids.add(ue.getSender());
					}
			}
			
			if(CollectionUtils.isNotEmpty(uids)) {
				Map<String,UserBaseVO> usersMap = userService.getAllUserMapByUid(uids);
				
				for(UserMessageEntity ue : userSendMsgsList) {
					UserBaseVO vo = usersMap.get(ue.getSender());
					if(null == vo || StringUtils.isBlank(vo.getUserName())) {
						continue;
					}
					ue.setSenderName(vo.getUserName());
				}
			}
		}
	}

	/**
	 * 查询所有满足条件的已接收的消息
	 * 
	 * @return
	 */
	public Map<String, Object> getAllRecMsgsByProperties(Map<String, Object> dataMap) {
		Map<String, Object> respMap = new HashMap<String, Object>();
		String userName = null;
		String tenantId = getTenantId();
		String uid = getUserId();//InvocationInfoProxy.getUserid();
		try {
			if(StringUtils.isNotBlank(tenantId)) {
				dataMap.put("tenantid", tenantId);
			}
		
			String readStatus = null == dataMap.get("status") ? "0" : dataMap.get("status").toString();
			
			String pageSize = null != dataMap.get("pagesize") ? dataMap.get("pagesize").toString() : "10";
			String currentPage = null == dataMap.get("pagenum") ? "1" : dataMap.get("pagenum").toString();
			int startIndex = (Integer.valueOf(currentPage) - 1) * Integer.valueOf(pageSize);
			dataMap.put("startIndex", startIndex);
			dataMap.put("pageSize", Integer.valueOf(pageSize));
			dataMap.put("status", new String[]{"0","1","2"});
			dataMap.put("readStatus", new String[]{readStatus});
			dataMap.put("recMsgDr", new String[]{"0"});
			
			//查询用户已发送的消息
			List<UserMessageEntity> userSendMsgsList = this.messageManageService.queryAllRecdMsgs(dataMap);
			
			UserBaseVO vo = userService.findUserById(uid);
			if(null != vo) {
				userName = vo.getUserName();
			}
			Integer totalDataNums = this.messageManageService.queryAllRecdMsgsNum(dataMap);
			//匹配对应的收件人
			if(StringUtils.isNotBlank(userName)) {
				for(UserMessageEntity ue : userSendMsgsList) {
					ue.setReceverName(userName);
				}
			}
			//匹配对应的发件人
			getMsgSenderInfo(userSendMsgsList);
			
			List<Map<String,Object>> msgNumList = new ArrayList<Map<String,Object>>();
			Map<String, Object> numMap = new HashMap<String, Object>();
			numMap.put("num", totalDataNums != null ? totalDataNums : 0);
			msgNumList.add(new HashMap<String, Object>());
			msgNumList.add(numMap);
			msgNumList.add(new HashMap<String, Object>());
			
			//查询结果返回
			List<MsgTypeEntity> msgTypeList = this.msgTypeService.queryAllMsgType();
			respMap.put("msgtype", msgTypeList);
			respMap.put("current", currentPage);
			respMap.put("message", userSendMsgsList);
			respMap.put("status", Integer.valueOf(1));
			respMap.put("msgnum", msgNumList);
			
			Map<String, Object> returnMap = new HashMap<String, Object>();
			returnMap.put("data", respMap);
			returnMap.put("status", Integer.valueOf(1));
			returnMap.put("msg", "消息查询成功");
			
			return returnMap;
		} catch (Exception e) {
			this.logger.error(e.getMessage(), e);
			respMap.put("data", "");
			respMap.put("msg", "消息查询出错");
			respMap.put("status", "0");
			return respMap;
		}
	}
	
	@RequestMapping(value="/delMsgs")
	@ResponseBody
	public Map<String, Object> updateMesgsStatus(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		String tenantId = getTenantId();
		Map<String, Object> dataMap;
		try {
			dataMap = getRequestData(request);
			if(StringUtils.isNotBlank(tenantId)) {
				dataMap.put("tenantid", tenantId);
			}
			
			List<String> sendMsgIds = (List<String>) dataMap.get("sendIds");
			List<String> recMsgIds = (List<String>) dataMap.get("recIds");
			String handleState = String.valueOf(dataMap.get("handleState"));
			if("null".equals(handleState) || StringUtils.isBlank(handleState)) {
				this.logger.error("参数错误，消息删除失败。");
				returnMap.put("msg", "参数错误，消息删除失败。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			String userId = null;
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (Cookie cookie : cookies) {
					if (cookie.getName().equals("userId")) {
						userId = cookie.getValue();
					}
				}
			}

			if (org.springframework.util.StringUtils.isEmpty(userId)) {
				userId = getUserId();
			}
			//更新已发送消息状态
			if(CollectionUtils.isNotEmpty(sendMsgIds)) {
				dataMap.put("sendMsgIdArr", sendMsgIds.toArray(new String[sendMsgIds.size()]));
				dataMap.put("senderUid", userId);
				List<UserMessageEntity> msgList = messageManageService.queryMsgByIdArr(dataMap);
				if(CollectionUtils.isNotEmpty(msgList)) {
					for(UserMessageEntity ue : msgList) {
						ue.setStatus(handleState);
						messageManageService.updateUserMsgHandleState(ue);
					}
				}
			}
			//更新已接收消息状态
			if(CollectionUtils.isNotEmpty(recMsgIds)) {
				dataMap.put("receiverUid", userId);
				dataMap.put("recMsgIdArr", recMsgIds.toArray(new String[recMsgIds.size()]));
				dataMap.put("recevierUid", userId);
				List<UserRecMsgEntity> recMsgList = this.messageManageService.queryMsgReceiverByIds(dataMap);
				if(CollectionUtils.isNotEmpty(recMsgList)) {
					for(UserRecMsgEntity mre : recMsgList) {
						mre.setDr(handleState);
						messageManageService.updateUserRecMsgHandleState(mre);
					}
				}
			}

			returnMap.put("msg", "消息删除成功。");
			returnMap.put("status", Integer.valueOf(1));
			return returnMap;
		} catch (IOException e) {
			this.logger.error(e.getMessage(), e);
			returnMap.put("msg", "服务异常，消息删除失败。");
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}
	}
	
	/**
	 * 新建消息
	 * 
	 * @return
	 */
	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"/newMessage"})
	@ResponseBody
	public Map<String, Object> addNewMessage(HttpServletRequest request) {
		Map<String, Object> dataMap = new HashMap<String, Object>();
		Map<String, Object> returnMap = new HashMap<String, Object>();
		PushMsgParameter pmp = new PushMsgParameter();
		ObjectMapper mapper = new ObjectMapper();
		String sendman = null,	//消息发送人
			   msgType = null,	//消息类型
			   subject = null,	//消息主题
			   content = null;	//消息内容
			   
		try {
			request.setCharacterEncoding("UTF-8");
			dataMap = getRequestData(request);
			logger.info(this.getClass()+"-新建消息："+request.getParameter("data"));
			//参数校验
			sendman = (String) dataMap.get("sendman");
			
			if(StringUtils.isBlank(sendman)) {
				logger.error("发送消息失败，消息发送人为空。");
				returnMap.put("msg", "发送消息失败，消息发送人为空。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			List<String> receivers = (List<String>) dataMap.get("receiver");
			if(CollectionUtils.isEmpty(receivers)) {
				logger.error("发送消息失败，消息接收人为空。");
				returnMap.put("msg", "发送消息失败，消息接收人为空。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			
			msgType = (String) dataMap.get("msgtype");
			
			if(StringUtils.isBlank(msgType)) {
				logger.error("发送消息失败，消息类型为空。");
				returnMap.put("msg", "发送消息失败，消息类型为空。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			
			subject = (String) dataMap.get("subject");
			
			if(StringUtils.isBlank(subject)) {
				logger.error("发送消息失败，消息主题为空。");
				returnMap.put("msg", "发送消息失败，消息主题为空。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			if(CommonUtils.getStrLength(subject) > 200) {
				logger.error("发送消息失败，消息主题长度超出长度（中文最多100字）。");
				returnMap.put("msg", "发送消息失败，消息主题长度超出长度（中文最多100字）。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			
			content = (String) dataMap.get("content");
			if(StringUtils.isBlank(content)) {
				logger.error("发送消息失败，消息内容为空。");
				returnMap.put("msg", "发送消息失败，消息内容为空。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			if(CommonUtils.getStrLength(content) > 10000) {
				logger.error("发送消息失败，消息内容长度超出长度（中文最多5000字）。");
				returnMap.put("msg", "发送消息失败，消息内容长度超出长度（中文最多5000字）。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}
			
			pmp.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});	//信息渠道
			String tenantId = getTenantId();
			if(StringUtils.isNotBlank(tenantId)) {	//租户ID
				pmp.setTenantid(tenantId);
			}
			
			pmp.setSendman(sendman);
			pmp.setRecevier(receivers.toArray(new String[receivers.size()]));	//消息接收人
			pmp.setMsgtype(msgType);
			pmp.setSubject(subject);
			pmp.setContent(content);
			
			//设置消息队列
			pmp.setQueueName(PushMsgParameter.QUEUENAME_MSGCENTER);
			
			String jsonString = pushMsgService.pushMessage(pmp);
			Map<String, Object> respMap = (Map<String, Object>) mapper.readValue(jsonString, HashMap.class); 
			if(null != respMap.get("success") && (Boolean)respMap.get("success")) {
				returnMap.put("msg", "发送消息成功");
				returnMap.put("status", Integer.valueOf(1));
			} else {
				returnMap.put("msg", "服务异常，发送消息失败");
				returnMap.put("status", Integer.valueOf(0));
			}
//			System.out.println(ReflectionToStringBuilder.toString(pmp));
//			returnMap.put("msg", "发送消息成功");
//			returnMap.put("status", Integer.valueOf(1));
			return returnMap;
		} catch (Exception e) {
			returnMap.put("msg", "发送消息失败，服务异常。");
			returnMap.put("status", Integer.valueOf(0));
			logger.error("发送消息失败，服务异常。", e);
			return returnMap;
		}
	}
	
	/**
	 * 查询单条信息详情
	 * 
	 * @param messageId
	 * @return
	 */
	@RequestMapping(value="/messageInfo")
	@ResponseBody
	public Map<String, Object> getMessage(@RequestParam(required = true, value = "msgId") String messageId) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		
		try {
			UserMessageEntity ume = this.messageManageService.getById(messageId);
			
			List<UserMessageEntity> list = new ArrayList<UserMessageEntity>();
			list.add(ume);
			getMsgReceiverInfo(list);
			getMsgSenderInfo(list);
			
			returnMap.put("message", ume);
			returnMap.put("msg", "获取消息成功。");
			returnMap.put("status", Integer.valueOf(1));
			return returnMap;
		} catch (Exception e) {
			returnMap.put("msg", "服务异常，查询消息失败。");
			returnMap.put("status", Integer.valueOf(0));
			logger.error("服务异常，查询消息失败。", e);
			return returnMap;
		}
	}
}