package com.yonyou.uap.message.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.message.entity.MsgChannel;
import com.yonyou.uap.message.service.IMessageChannel;
import com.yonyou.uap.service.ISenderInfoFetch;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SenderInfoFetchByDB implements ISenderInfoFetch {
	private Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IMessageChannel messageChannel;

	@SuppressWarnings("unchecked")
	public Map<String, Object> getSenderInfo(String channel) {
		Map<String,Object> sendTypeInfoMap = null;

		MsgChannel msgChannel = this.messageChannel.queryMsgByCode(channel);

		if (msgChannel != null) {
			String sendType = msgChannel.getType();

			String configInfo = msgChannel.getConfiginfo();
			JSONObject jsonObject = JSONObject.fromObject(configInfo);

			if (jsonObject != null) {
				sendTypeInfoMap = new HashMap<String,Object>();
				if (sendType.equals("mail")) {
					String userName = jsonObject.getString("userName");
					String userPwd = jsonObject.getString("userPwd");
					String hostName = jsonObject.getString("hostName");
					sendTypeInfoMap.put("userName", userName);
					sendTypeInfoMap.put("userPwd", userPwd);
					sendTypeInfoMap.put("hostName", hostName);
					sendTypeInfoMap.put("type", "mail");
				} else if (sendType.equals("messagepush")) {
					String userName = jsonObject.getString("userName");
					String userKey = jsonObject.getString("userKey");
					String url = jsonObject.getString("url");
					sendTypeInfoMap.put("userName", userName);
					sendTypeInfoMap.put("userKey", userKey);
					sendTypeInfoMap.put("url", url);
					sendTypeInfoMap.put("type", "messagepush");
				} else if (sendType.equals("sms")) {
					String corpId = jsonObject.getString("corpId");
					String secretKey = jsonObject.getString("secretKey");
					String url = jsonObject.getString("url");
					sendTypeInfoMap.put("corpId", corpId);
					sendTypeInfoMap.put("secretKey", secretKey);
					sendTypeInfoMap.put("url", url);
					sendTypeInfoMap.put("type", "sms");
				} else {
					ObjectMapper mapper = new ObjectMapper();
					try {
						sendTypeInfoMap = (Map<String,Object>) mapper.readValue(jsonObject.toString(), Map.class);
					} catch (IOException e) {
						this.logger.error("消息通道参数配置解析错误", e);
					}
					sendTypeInfoMap.put("type", sendType);
				}
			}
		}

		return sendTypeInfoMap;
	}
}