package com.yonyou.uap.msg.template.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.msg.template.entity.MessageEntity;
import com.yonyou.uap.msg.template.service.IMsgTemplateCreate;
import com.yonyou.uap.msg.template.service.IMsgTemplateDataSource;
import com.yonyou.uap.msg.template.service.impl.MsgTemplateDefaultBusiVarImpl;
import com.yonyou.uap.msgtemplate.exception.MsgBusinessException;

@SuppressWarnings("unchecked")
@RestController
@RequestMapping({ "/message/template" })
public class MsgCreateController {
	private static final Logger logger = LoggerFactory.getLogger(MsgCreateController.class);

	@Autowired
	private IMsgTemplateCreate msgTemplateCreate;

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = { "/create" })
	@ResponseBody
	public Object createMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String,Object> returnMap = new HashMap<String,Object>();

		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		String templateCode = null;
		Map<String,Object> busiData = null;
		Map<String,Object> dataMap = null;
		try {
			dataMap = (Map<String,Object>) mapper.readValue(jsonString, HashMap.class);
			templateCode = String.valueOf(dataMap.get("templateCode"));
			busiData = (Map<String,Object>) dataMap.get("busiData");
		} catch (IOException e) {
			logger.error("JSON转换成Map时出错，jsonString : " + dataMap, e);
			returnMap.put("msg", "JSON转换成Map时出错，jsonString : " + dataMap);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		} catch (Exception e) {
			logger.error("传入的业务参数有误，busiData : " + dataMap, e);
			returnMap.put("msg", "传入的业务参数有误，busiData : " + dataMap);
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}
		if (dataMap != null) {
			IMsgTemplateDataSource defaultBusiVarImpl = new MsgTemplateDefaultBusiVarImpl(busiData);
			MessageEntity messageEntity = null;
			try {
				messageEntity = this.msgTemplateCreate.createMessageByCode(templateCode, defaultBusiVarImpl);
			} catch (MsgBusinessException e) {
				logger.error("创建信息模板失败。", e);
				returnMap.put("msg", "创建信息模板失败。");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}

			returnMap.put("msg", messageEntity);
			returnMap.put("status", Integer.valueOf(1));
		}

		return returnMap;
	}
}