package com.yonyou.uap.msg.template.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yonyou.uap.msg.template.entity.MsgTemplateEntity;
import com.yonyou.uap.msg.template.entity.MsgTemplateManageEntity;
import com.yonyou.uap.msg.template.sdk.BusiObjectService;
import com.yonyou.uap.msg.template.service.IMsgTemplateManageService;
import com.yonyou.uap.msg.template.service.IMsgTemplateService;
import com.yonyou.uap.msgtemplate.exception.MsgBusinessException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@SuppressWarnings("unchecked")
@Controller
@RequestMapping({ "/message/template" })
public class MsgTemplateController {
	private final Logger logger = LoggerFactory.getLogger(MsgTemplateController.class);

	@Autowired
	private IMsgTemplateService msgTemplateService;

	@Autowired
	private IMsgTemplateManageService msgTempManageService;

	@Autowired
	private BusiObjectService busiObjectService;

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = { "/data" })
	@ResponseBody
	public Object queryMsgChannel(HttpServletRequest request, HttpServletResponse response) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		String dataString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		try {
			Map<String,Object> getDataMap = (Map<String,Object>) mapper.readValue(dataString, HashMap.class);
			Object idObj = getDataMap.get("id");
			Object tempGroupObj = getDataMap.get("tempgroup");

			String id = null;
			String tempManageId = null;
			MsgTemplateEntity template = new MsgTemplateEntity();
			if (!org.springframework.util.StringUtils.isEmpty(idObj)) {
				id = String.valueOf(idObj);
				template = this.msgTemplateService.queryMsgTemplateById(id);
				if (template != null) {
					tempManageId = template.getTempgroup();
				}
			}
			if (!org.springframework.util.StringUtils.isEmpty(tempGroupObj)) {
				tempManageId = String.valueOf(tempGroupObj);
			}

			MsgTemplateManageEntity tempTypeEntity = this.msgTempManageService.queryMsgTempTypeById(tempManageId);
			String entityid = tempTypeEntity.getEntityid();
			if (org.apache.commons.lang.StringUtils.isBlank(entityid)) {
				returnMap.put("data", "");
				returnMap.put("msg", "消息模板业务对象查询失败!");
				returnMap.put("status", Integer.valueOf(0));
				return returnMap;
			}

			List<Map<String, String>> busiObjectList = this.busiObjectService.queryBusiObject(entityid);
			Map<String, Object> dataMap = new HashMap<String, Object>();
			dataMap.put("template", template);
			dataMap.put("busiObj", busiObjectList);
			returnMap.put("data", dataMap);
			returnMap.put("msg", "消息模板查询成功!");
			returnMap.put("status", Integer.valueOf(1));
		} catch (MsgBusinessException | IOException e) {
			returnMap.put("data", "");
			returnMap.put("msg", "消息模板查询失败!");
			returnMap.put("status", Integer.valueOf(0));
			this.logger.error(e.getMessage(), e);
		}

		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"updateMsgTemplate" })
	@ResponseBody
	public Map<String, Object> updateMsgTemplate(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();

		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		try {
			Map<String,Object> dataMap = (Map<String,Object>) mapper.readValue(jsonString, HashMap.class);
			String id = (String) dataMap.get("id");
			Map<String,String> templateMap = (Map<String,String>) dataMap.get("template");
			MsgTemplateEntity template = new MsgTemplateEntity();
			if (org.apache.commons.lang.StringUtils.isNotBlank(id)) {
				template = this.msgTemplateService.queryMsgTemplateById(id);
				if (!template.getCode().equals(templateMap.get("code"))) {
					MsgTemplateEntity qtTemplate = this.msgTemplateService.queryMsgTemplateByCode((String) templateMap.get("code"));
					if (qtTemplate != null) {
						returnMap.put("msg", "消息模版编码已经存在");
						returnMap.put("status", Integer.valueOf(0));
						return returnMap;
					}
				}
			} else {
				MsgTemplateEntity qTemplate = this.msgTemplateService
						.queryMsgTemplateByCode((String) templateMap.get("code"));
				if (qTemplate != null) {
					returnMap.put("msg", "消息模版编码不允许重复");
					returnMap.put("status", Integer.valueOf(0));
					return returnMap;
				}
			}
			template.setCode((String) templateMap.get("code"));
			template.setName((String) templateMap.get("name"));
			template.setNote((String) templateMap.get("note"));
			template.setTitle((String) templateMap.get("title"));
			template.setData((String) templateMap.get("data"));
			template.setTempgroup((String) templateMap.get("tempgroup"));
			this.msgTemplateService.save(template);

			returnMap.put("msg", "消息模板保存成功");
			returnMap.put("status", Integer.valueOf(1));
		} catch (MsgBusinessException | IOException e) {
			returnMap.put("data", "");
			returnMap.put("msg", "消息模板保存失败");
			returnMap.put("status", Integer.valueOf(0));
			this.logger.error(e.getMessage(), e);
		}

		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"saveMsgTempManage" })
	@ResponseBody
	public Map<String, Object> saveMsgTempManage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();

		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		try {
			Map<String, Object> dataMap = (Map<String, Object>) mapper.readValue(jsonString, HashMap.class);
			String id = (String) dataMap.get("id");
			Map<String,String> tempTypeMap = (Map<String,String>) dataMap.get("tempType");
			MsgTemplateManageEntity tempType = new MsgTemplateManageEntity();
			if (org.apache.commons.lang.StringUtils.isNotBlank(id)) {
				tempType = this.msgTempManageService.queryMsgTempTypeById(id);
				if (tempType == null) {
					tempType = new MsgTemplateManageEntity();
				}

			}

			MsgTemplateEntity queryMsgTemplateByCode = this.msgTemplateService
					.queryMsgTemplateByCode((String) tempTypeMap.get("code"));

			if (queryMsgTemplateByCode == null) {
				tempType.setCode((String) tempTypeMap.get("code"));
				tempType.setName((String) tempTypeMap.get("name"));
				tempType.setEntityid((String) tempTypeMap.get("entityid"));
				tempType.setFatherid((String) tempTypeMap.get("fatherid"));
				tempType.setIsdirectory((String) tempTypeMap.get("isdirectory"));
				tempType.setIsfixed((String) tempTypeMap.get("isfixed"));
				this.msgTempManageService.save(tempType);
				returnMap.put("msg", "消息模板分类保存成功");
				returnMap.put("status", Integer.valueOf(1));
			} else {
				returnMap.put("msg", "消息模版编码不允许重复");
				returnMap.put("status", Integer.valueOf(0));
			}
		} catch (MsgBusinessException | IOException e) {
			returnMap.put("data", "");
			returnMap.put("msg", "消息模板分类保存失败");
			returnMap.put("status", Integer.valueOf(0));
			this.logger.error(e.getMessage(), e);
		}

		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = { "getTempTypes" })
	@ResponseBody
	public Map<String, Object> getTempTypes(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		try {
			List<MsgTemplateManageEntity> msgTempTypeList = this.msgTempManageService.queryAlltempTypes();
			returnMap.put("data", msgTempTypeList);
			returnMap.put("msg", "");
			returnMap.put("status", Integer.valueOf(1));
		} catch (MsgBusinessException e) {
			this.logger.error("消息模板分类查询出错", e);
			returnMap.put("data", "");
			returnMap.put("msg", "消息模板分类查询出错");
			returnMap.put("status", Integer.valueOf(1));
		}
		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.POST }, value = {"/getTempsByType" })
	@ResponseBody
	public Object getTempByTypeId(HttpServletRequest request, HttpServletResponse response) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		String jsonString = request.getParameter("data");
		ObjectMapper mapper = new ObjectMapper();
		Map<String, String> dataMap = null;
		try {
			dataMap = (Map<String, String>) mapper.readValue(jsonString, HashMap.class);
		} catch (IOException e) {
			this.logger.error(e.getMessage(), e);
			returnMap.put("data", "");
			returnMap.put("msg", "参数转换出错");
			returnMap.put("status", "0");
			return returnMap;
		}
		String groupId = (String) dataMap.get("groupId");
		if (org.apache.commons.lang.StringUtils.isEmpty(groupId)) {
			returnMap.put("msg", "消息模板分类为空，无法加载消息模板数据");
			returnMap.put("status", Integer.valueOf(0));
			return returnMap;
		}
		try {
			Map<String, Object> searchMap = buildSearchMap(dataMap);
			List<MsgTemplateEntity> tempList = this.msgTemplateService.queryTempsBySearchMap(searchMap);

			Map<String, Object> queryAllNumberMap = buildAllNumberMap(dataMap);
			int numbers = this.msgTemplateService.queryMsgTempNumbers(queryAllNumberMap);
			Map<String,Object> tempDataMap = new HashMap<String,Object>();
			tempDataMap.put("tempList", tempList);
			tempDataMap.put("nums", Integer.valueOf(numbers));
			returnMap.put("data", tempDataMap);
			returnMap.put("msg", "");
			returnMap.put("status", Integer.valueOf(1));
		} catch (MsgBusinessException e) {
			this.logger.error("消息模板查询出错", e);
			returnMap.put("data", "");
			returnMap.put("msg", "消息模板查询出错");
			returnMap.put("status", Integer.valueOf(1));
		}
		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = { "/delete/{id}" })
	@ResponseBody
	public Object deleteMsgTemplateById(@PathVariable("id") String id) {
		Map<String,Object> returnMap = new HashMap<String,Object>();
		try {
			this.msgTemplateService.deleteById(id);
			returnMap.put("msg", "模板删除成功!");
			returnMap.put("status", "1");
		} catch (MsgBusinessException e) {
			this.logger.error(e.getMessage(), e);
			returnMap.put("msg", "模板删除出错！");
			returnMap.put("status", "0");
		}

		return returnMap;
	}

	private Map<String, Object> buildAllNumberMap(Map<String, String> dataMap) {
		String search = (String) dataMap.get("search");
		String tempgroup = (String) dataMap.get("groupId");

		Map<String, Object> searchMap = new HashMap<String, Object>();
		if (!org.apache.commons.lang.StringUtils.isEmpty(search)) {
			String searchContent = "%" + search + "%";
			searchMap.put("search", searchContent);
		}

		if ((org.apache.commons.lang.StringUtils.isNotBlank(tempgroup)) && (!tempgroup.equals("all"))) {
			searchMap.put("tempgroup", tempgroup);
		}

		return searchMap;
	}

	private Map<String, Object> buildSearchMap(Map<String, String> dataMap) {
		String currentPageStr = String.valueOf(dataMap.get("pagenum"));
		String pageSizeStr = String.valueOf(dataMap.get("pagesize"));
		String search = (String) dataMap.get("search");
		String tempgroup = (String) dataMap.get("groupId");

		int currentPage = 0;
		int pageSize = 0;
		Map<String,Object> searchMap = new HashMap<String,Object>();
		if (org.apache.commons.lang.StringUtils.isEmpty(currentPageStr))
			currentPage = 9;
		else {
			currentPage = Integer.valueOf(currentPageStr).intValue();
		}
		if (org.apache.commons.lang.StringUtils.isEmpty(pageSizeStr))
			pageSize = 1;
		else {
			pageSize = Integer.valueOf(pageSizeStr).intValue();
		}

		int startIndex = (currentPage - 1) * pageSize;
		if (startIndex < 0) {
			startIndex = 0;
		}
		searchMap.put("startIndex", Integer.valueOf(startIndex));
		searchMap.put("pageSize", Integer.valueOf(pageSize));

		if (!org.apache.commons.lang.StringUtils.isEmpty(search)) {
			String searchContent = "%" + search + "%";
			searchMap.put("search", searchContent);
		}

		if ((org.apache.commons.lang.StringUtils.isNotBlank(tempgroup)) && (!tempgroup.equals("all"))) {
			searchMap.put("tempgroup", tempgroup);
		}
		return searchMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = {"/getBusiObject" })
	@ResponseBody
	public Map<String, Object> queryMsgBusinessObject(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> returnMap = new HashMap<String, Object>();

		return returnMap;
	}

	@RequestMapping(method = { org.springframework.web.bind.annotation.RequestMethod.GET }, value = { "/test/{code}" })
	@ResponseBody
	public Object queryMsgTemplateChannel(@PathVariable("code") String code) {
		Map<String, Object> returnMap = new HashMap<String, Object>();
		try {
			MsgTemplateEntity template = this.msgTemplateService.queryMsgTemplateByCode(code);
			returnMap.put("data", template);
		} catch (MsgBusinessException e) {
			returnMap.put("msg", "查询出错！");
		}

		return returnMap;
	}
}