package com.yonyou.uap.msg.template.service.impl;

import com.yonyou.iuap.generic.adapter.InvocationInfoProxyAdapter;
import com.yonyou.uap.msg.template.dao.MsgTemplateManageMapper;
import com.yonyou.uap.msg.template.entity.MsgTemplateManageEntity;
import com.yonyou.uap.msg.template.service.IMsgTemplateManageService;
import com.yonyou.uap.msgtemplate.exception.MsgBusinessException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MsgTemplateManageServiceImpl implements IMsgTemplateManageService {

	@Autowired
	private MsgTemplateManageMapper mapper;

	public MsgTemplateManageEntity queryMsgTempTypeById(String id) throws MsgBusinessException {
		return this.mapper.queryMsgTempTypeById(id);
	}

	public void save(MsgTemplateManageEntity entity) throws MsgBusinessException {
		if (StringUtils.isEmpty(entity.getId())) {
			entity.setId(UUID.randomUUID().toString());
			String tenantid = InvocationInfoProxyAdapter.getTenantid();
			entity.setTenantid(tenantid);
			this.mapper.insert(entity);
		} else {
			this.mapper.update(entity);
		}
	}

	public void delete(MsgTemplateManageEntity entity) throws MsgBusinessException {
		this.mapper.delete(entity);
	}

	public List<MsgTemplateManageEntity> queryAlltempTypes() throws MsgBusinessException {
		String tenantid = InvocationInfoProxyAdapter.getTenantid();
		return this.mapper.queryAlltempTypes(tenantid);
	}
}