package com.yyjz.icop.usercenter.common;

import java.util.HashMap;
import java.util.Map;

public enum UserSysEnums {
	
	USERSYS_TYPE_BASIC("基础组织","BASICXT", "1", null),
	USERSYS_TYPE_DJ("党建云子系统","DJYZXT", "2", "党组织");
	
	private String name;
	private String code;
	private String type;
	private String displayName;
	
	private static Map<String, UserSysEnums> sysMaps = null;
	
	private UserSysEnums(String name, String code, String type, String displayName) {
		this.name = name;
		this.code = code;
		this.type = type;
		this.displayName = displayName;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	
	public static UserSysEnums getEnumByCode(String code) {
		if(null == sysMaps) {
			sysMaps = new HashMap<String, UserSysEnums>();
			for(UserSysEnums e : values()) {
				sysMaps.put(e.getCode(), e);
			}
		}
		return sysMaps.get(code);
	}
}
