package com.yyjz.icop.usercenter.service;

import java.util.List;

import com.yyjz.icop.usercenter.vo.PartmemberMappingVO;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

/**
 * @author CJ
 *
 */
public interface IPartmemberMappingService {

	List<PartmemberMappingVO> save(List<PartmemberMappingVO> ptmlist) throws Exception;

	List<PartmemberMappingVO> findByIdentifyCard(String credentialCode);
	
	PartmemberMappingVO findOneByIdentifyCard(String credentialCode);

	PartmemberMappingVO save(PartmemberMappingVO pe) throws Exception;

	List<PartmemberMappingVO> getAllByPartOrgIds(List<String> partOrgIds);

	List<UserBaseVO> getAllUserByPartOrgSourceId(String parOrSourcegId, String isContainBelow, int startIndex, int pageSize);

	int getAllUserCountByPartOrgId(String parOrgId, String isContainBelow);

	/**
	 * 根据系统编码、用户Id查询对应的党员关系
	 * 
	 * @param sysCode
	 * @param userId
	 * @return
	 */
	PartmemberMappingVO findByUserId(String userId, String sysCode);

	int countUsersByProperties(String companyId, String param, String iscontainBelow);
	/**
	 * 党员主职、兼职
	 * 
	 * @param userId
	 * @param code
	 * @return
	 */
	List<PartmemberMappingVO> queryAllByUserId(String userId, String code);

}
