package com.yyjz.icop.usercenter.service;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.usercenter.vo.SupplierExtVO;
import com.yyjz.icop.usercenter.vo.UserVO;

public interface ISupplierService {
	public JSONObject addSuppliers(UserVO[] userVOs);
	
	public JSONObject addSuppliers(List<UserVO> userVOs);
	
	public JSONObject addSupplier(UserVO userVO);

	public void outerUserService(JSONObject outerUser, String userId);
	
	/**
	 * 创建供应商信息，包括组织，部门，人员，用户，角色，用户权限
	 * @param supplierCode 供方编号
	 * @param supplierName 供方名称
	 * @param supplierShorName 供方简称
	 * @param tel 电话号码
	 * @param supplierCreditCode 社会信用统一代码
	 * @param sourceSys 来源系统，默认为“共享中心”
	 * @param supplierDocId 来源系统id， 为供方档案主键
	 * @param address 分供方注册地址
	 * @return
	 */
	/*JSONObject createSuppliers(
			String supplierCode, 
			String supplierName, 
			String supplierShorName,
			String tel,
			String supplierCreditCode,
			String sourceSys,
			String supplierDocId,
			String address);*/
	
	/**
	 * 创建供应商档案接口
	 * @return
	 */
	JSONObject createSuppliers(SupplierExtVO supplierExtVO);
	
	/**
	 * 批量创建供应商
	 * @param supplierExtVO
	 * @return
	 */
	JSONObject createSuppliersBatch(List<SupplierExtVO> supplierExtVO);

	public void outerUserServiceNew(JSONObject outerUser, String userId);
}
