package com.yyjz.icop.usercenter.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.usercenter.vo.UserExtNewVO;
import com.yyjz.icop.usercenter.vo.UserExtRelationVO;
import com.yyjz.icop.usercenter.vo.UserExtVO;
import com.yyjz.icop.usercenter.vo.UserSysVO;
import com.yyjz.icop.usercenter.vo.UserThirdVO;

public interface IUserExtService {
	/**
	 * @param vo
	 * @return
	 * 写入pub_tenant_user_ext表中，表示用户的扩展（供应方等等）
	 */
	UserExtVO addUserExt(UserExtVO vo);
	
	UserExtVO getOneUserExtByUserId(String uesrId);
	
	List<String> getAllUserIds();

	List<UserThirdVO> getAllUsersBySysid(String sysid);

	List<UserExtVO> getUsersByIdNumbers(String sysid, List<String> idNumbers);

	void updateBatch(List<UserExtVO> extVOsExist);
	
	Map<String, String> getUsersByCode(String sysCode, String userCode);
	
	List<UserThirdVO> getUser(String userId, String syscode);
	Map<String, String> getSysByCode(String code);

	List<UserExtNewVO> pageUserExt(int pageNumber,int pageSize, String userName, String sysId);

	int getCountUserExt(String userName, String sysId);

	UserExtNewVO findUserExt(String id);
	
	UserSysVO getSysInfoBycode(String syscode);
	
	Map<String,Object> getTonoInfo(String is_binding,String syscode,String tono,String toname);

	/**
	 * 根据第三方系统账号和系统标识获取平台用户编号的接口。
	 * @param sysCode 第三方系统id
	 * @param userCodes 第三方系统账号
	 * @return 如果第三方系统没有绑定icop平台账号，则直接返回，如果第三方系统已经绑定icop账号，返回绑定后的icop账号和第三方系统账号的映射
	 */
	public Map<String, Object> getUsersByCodes(String sysCode, List<String> userCodes) throws BusinessException;
}
