package com.yyjz.icop.usercenter.service;

import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.usercenter.vo.UserLoginVO;

import java.util.List;
import java.util.Map;

/**
	ma，bpm登录认证接口
 */
public interface IUserLVService {
	
	public static final String[] AUTH_KEYS = {"u_logints", "u_usercode", "tenantid", "userId", "userType", "token", "typeAlias"};
	
	ObjectResponse<JSONObject> modifyPassword(UserLoginVO userVO);

	JSONObject process(String type, JSONObject userContext, HttpServletRequest request, HttpServletResponse response,
			JSONObject result, String userName, JSONObject json);

	String getAuthenticationStr(JSONObject auth);

	ObjectResponse<JSONObject> forgetPassword(UserLoginVO userVO);

	JSONObject getUserContext(ServletRequest req, String authority, String userId, String roleId,String sourceType,String companyId);

	/**
	 * 查询组织直接下级
	 * @param orgId 组织 主键
	 * @param orgType  DJ 党组织， 其他 普通组织
	 * @return
	 */
	List<Map<String,Object>> getSubOrgs(String orgId, String orgType);

	JSONObject webLoginAndValidate(UserLoginVO userVO);

	JSONObject getUserContext(ServletRequest req, String authority, String userId);

	void requestUserContextWithCredentials(JSONObject userContext, Cookie[] cookies);

	String getWebsiteContext(String userName);

	JSONObject searchCompanys(String searchText, String companyIds);
}
