package com.yyjz.icop.usercenter.service;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.base.exception.BusinessException;
import com.yyjz.icop.usercenter.vo.PartmemberMappingVO;
import com.yyjz.icop.usercenter.vo.PartmemberRelationUserVO;
import com.yyjz.icop.usercenter.vo.UserBaseVO;
import com.yyjz.icop.usercenter.vo.UserLoginVO;
import com.yyjz.icop.usercenter.vo.UserVO;

public interface IUserService {
	
	public List<UserVO>  getUserList(String tenantId,String ts,String start,String count)throws ParseException;

	public int getPageCount(String ts, String count);

	public List<UserVO> getUserListByapk(String[] userIds);
	
	public String getUsersByPks(String[] userIds);
	
	public String findById(String userId);

	public UserBaseVO findUserById(String userId);
	
	public com.alibaba.fastjson.JSONObject findUserByCode(String userCode);

	public String getUserNoStaffList(String tenantId, String orderCondition);
	
	JSONObject addOuterUser(UserVO svo);

	/**
	 * 保存用户
	 * @param user
	 * @return
     */
	UserBaseVO saveUser(UserBaseVO user) throws BusinessException;

	/**
	 * 根据用户名，code，电话，邮箱模糊查询
	 * @param pageRequest
	 * @param param
     * @return
     */
	Page<UserBaseVO> pageUser(PageRequest pageRequest, final String param, String companyId);

	/**
	 * 分页获取当前组织下所有用户
	 * @param pageRequest
	 * @param searchText
	 * @param companyId
     * @return
     */
	Page<UserBaseVO> pageUserByCompanyId(PageRequest pageRequest, String searchText, String companyId);

	/**
	 * 根据用户id删除用户
	 * @param id
	 * @return
     */
	boolean deleteUser(String id) throws BusinessException;

	/**
	 * 根据code查询用户信息
	 * @param userCode
     * @return
     */
	List<UserBaseVO> findByCode(String userCode);
	
	/**
	 * 根据companyId查询用户所有信息
	 * @param companyId
     * @return
     */
	List<UserVO> findUserVOByCompanyId(List<String> companyIds);

	/**
	 * 根据companyId查询用户信息
	 * @param companyId
     * @return
     */
	List<String> findByCompanyId(List<String> companyIds);

	/**
	 * find UserBaseVO by userEmail
	 * @param userEmail
     * @return
     */
	List<UserBaseVO> findByEmail(String userEmail);

	/**
	 * find UserBaseVO by userMobile
	 * @param userMobile
     * @return
     */
	List<UserBaseVO> findByMobile(String userMobile);

	/**
	 * @param tenantId
	 * @param deptId
	 * @return 获取指定部门下的用户
	 */
	public String getUserByDeptId(String tenantId, String deptId);
	public Page<UserBaseVO> getUserByDeptId(String deptId, final String searchText,int  pageNumber, int pageSize);
	public String getUserByPositionId(String tENANT_ID, String[] positionIds);

	/**
	 * @param tenantId
	 * @param deptId
	 * @return 获取指定部门下的用户
	 */
	public List<UserVO> getUserVOByDeptId(String tenantId, String deptId);
	
	/**
	 * @param tenantId
	 * @param roleIds
	 * @return	
	 * 根据roleId获取角色下面的用户，支持 批量 	
	 */
	public String getUserByRoleId(String tenantId, List<String> roleIds);
	
	/**
	 * @param tenantId
	 * @param positionDirectoryIds
	 * @return
	 * 根据岗位字典id 获取下面的用户，支持批量
	 */
	public String getUserByPositionDictionaryId(String tenantId, List<String> positionDirectoryIds);
	
	public List<UserVO> findNoStaffUser(String tenantId,int pageNo,int pageSize,List<String> strs,String searchText,String orderBy);
	
	public int findNoStaffUserCount(String tenantId,List<String> strs,String searchText);

	public List<UserBaseVO> findUsersByIds(String tenantId, List<String> userIds);
	//todo
	public String updateBatch(List<UserBaseVO> userVOExist);

	public List<UserBaseVO> findByCodeInTenant(String userCode);

	public List<UserVO> findNoStaffUserIncludeExt(String tenantId, List<String> userIds, String searchText, String orderBy);

	Page<UserBaseVO> findUsersByTypeId(PageRequest pageRequest, String tenantId, String param, String typeId);

	public UserBaseVO findByLoginName(String userCode);
	
	public int getCountTenantUser(String tenantId, String searchText);

	public List<UserBaseVO> pageTenantUser(int pageNumber, int pageSize, String tenantId, String searchText);

	public List<UserBaseVO> findAllUserByUserName(String userName);
	//根据提供商id查询提供商管理员信息
	public UserBaseVO findUserBySupplierId(String id);
	//提供给共享中心使用
	public void updateUserSupplierId(String userId, String supplierId);

	public Page<UserBaseVO> pageTenancyUser(PageRequest pageRequest,
			String param);

	/**
	 * 根据用户Id查询对应的用户信息
	 * 
	 * @param uids
	 * @return
	 */
	public Map<String, UserBaseVO> getAllUserMapByUid(List<String> uids);

	public UserBaseVO findSuperUserByTenantId(String tenantId);

	/**
	 * 查询所有以指定编码开头数字结尾的用户
	 * @param userCode
	 * @return
	 */
	public List<UserBaseVO> findAllByCode(String userCode);

	public int getCountByByUserIdsAll(List<String> userIds, String searchText);

	public List<UserBaseVO> searchStaffsByUserIdsAll(List<String> userIds, String searchText, int pageNum,
			int pageSize);

	public List<UserBaseVO> searchUsersByPartOrgIds(List<String> partOrgIds, String searchText);
	List<UserBaseVO> search(String word) throws BusinessException;

	public Page<UserBaseVO> pageCompanyUser(PageRequest pageRequest,
			String companyId, String searchText);

	public int getSearchUserCountByPartOrgIds(List<String> partOrgIds, String searchText, List<String> userids);

	public List<UserBaseVO> searchUsersByPartOrgIds(List<String> partOrgIds, String searchText, int startIndex,
			int pageSize);

	public List<UserBaseVO> findAllByUserIds(List<String> userIds);
	
	public List<UserBaseVO> getPageUserByIds(List<String> userIds,int startIndex,int pageSize);

	public List<PartmemberRelationUserVO> searchAllUserByPartOrgIds(List<String> partOrgIds, String searchText,
				int pageNum, int pageSize, List<String> userids);

	public List<UserBaseVO> searchAllUserByProperties(String[] userIds, String searchText);

	public List<UserBaseVO> findPartmemberBindUsersByProperties(String companyId, String param, String iscontainBelow,
			int startIndex, int pageSize);

	/**
	 * 统计供应商数量
	 * @param param 
	 * 
	 * @return
	 */
	public int countSuppliers(String param);

	public List<UserBaseVO> getPageSuppliers(String param, int startIndex, int pageSize);

	/**
	 * 查询除内部员工、供应商之外的用户数量
	 * @param param 
	 * 
	 * @return
	 */
	public int countOtherTypeUsers(String param);

	public List<UserBaseVO> getPageOtherTypeUsers(String param, int startIndex, int pageSize);

	public int findNoStaffUserCountNew(String tenantid, List<String> userIds, String searchText);

	public List<UserVO> findNoStaffUserNew(String tenantid, int i, int pageSize, List<String> userIds,
			String searchText, String sortType);
	//todo
	public void clearBindsStatus(List<String> uids);

	public List<PartmemberMappingVO> queryAllByUserId(String userId, String code);
	
	/**
	 * 根据用户id查询对应用户Map<userIdStr, UserBaseVO>
	 * 
	 * @param uids
	 * @return
	 */
	public Map<String, UserBaseVO> findUsersMapByUserIds(List<String> uids);
	
	/**
	 * 根据组织Id、搜索关键字 统计对应内部用户的总数量
	 * @param companyId
	 * @param param
	 * @param iscontainBelow
	 * @return
	 */
	public int countInnerUsersByProperties(List<String> userIds);
	
	public List<UserBaseVO> findByAttributes(Map<String, String> param, boolean b);

	/**
	 * 更新用户表
	 * @param vo
	 * @return
	 */
	UserBaseVO updateUser(UserBaseVO vo) throws BusinessException;
	
	/**
	 * 新增组织/部门/人员时生成编码值
	 */
	public String getInsertCode(String ruleId);
	
	/**
	 * 手机号码注册校验
	 */
	public com.alibaba.fastjson.JSONObject judgeMobileandcode(UserLoginVO userVO);
	
	/**
	 * 管理员注册
	 */
	public com.alibaba.fastjson.JSONObject saveUserByMobileForadm(UserBaseVO vo);
	
	/**
	 * 按普通用户注册
	 */
	public com.alibaba.fastjson.JSONObject saveUserByMobileForcom(UserBaseVO vo);

	/**
	 * 根据用户code修改email
	 */
	public void updateUserEmailByCode(String userCode, String userEmail);
	
	public List<UserBaseVO> getUsersByUserName(String userName);

	/**
	 * 搜索满足条件的用户信息
	 * 
	 * @param uids
	 * @param searchText
	 * @param pageSize
	 * @param startIndex
	 * @return
	 */
	public List<UserBaseVO> searchPageUserByProperties(List<String> uids, String searchText, int pageSize, int startIndex);
	Page<UserBaseVO> pageAllUser(PageRequest pageRequest, String ts, String tenantId,int type);
	public Page<UserBaseVO> pageAllUser(String start, String count,String ts, String tenantId,int type);
	
	/**
	 * 根据微信公众号appid和secret获取access_token
	 * 
	 * @param appid
	 * @param secret
	 * @return
	 * 
	 * add by guominga 2018/03/28
	 */
	public String getWeixinAccessToken(String appid,String secret);
	
	/**
	 * 根据微信企业号corpAppId和corpSecret获取access_token
	 * 
	 * @param corpAppId
	 * @param corpSecret
	 * @return
	 */
	public String getWeixinCorpAccessToken(String corpAppId,String corpSecret) ;

	/**
	 * 根据用户ids获取用户属性
	 * 
	 * @param userIds
	 * @return
	 * 
	 * add by guominga 2018/03/28
	 */
	public Map<String, Map<String, String>> getUserMobileEmailMap(List<String> userIds);
	
	/**
	 * 根据用户编码和密码 查询用户是否存在
	 * @param userCode
	 * @param password 加密后的密文
	 * @return
	 */
	public int countUserByUserCodeAndPassword(String userCode, String password);
}
