/**  
* 创建时间：2017年2月24日 上午9:11:37  
* 项目名称：icop-usercenter-api  
* @author hjz  
* @version 1.0   
* @since JDK 1.6.0_21  
* 文件名称：IUserTenantService.java  
* 类说明：  
*/
package com.yyjz.icop.usercenter.service;

import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.usercenter.vo.UserBaseVO;

public interface IUserTenantAndSupplierService {

	/**
	 * @param tel
	 * @return
	 */
	boolean isTelExist(String tel);

	/**
	 * @param vo
	 * @return
	 */
	ObjectResponse<UserBaseVO> updateUser(UserBaseVO vo);

	/**
	 * @param vo
	 * @return
	 */
	ObjectResponse<UserBaseVO> saveUser(UserBaseVO vo);

	/**
	 * @param userTel
	 * @return
	 */
	UserBaseVO findAdminByMoblie(String userTel);

	/**
	 * @param userCode
	 * @return
	 */
	UserBaseVO findByUserCode(String userCode);

	/**
	 * @param uid
	 * @return
	 */
	UserBaseVO findByUserId(String uid);

	/**
	 * @param userTel
	 * @return
	 */
	UserBaseVO findSupplierByMoblie(String userTel);

	/**
	 * 绑定用户ID和openId
	 * 
	 * @param userCode
	 * @param openId
	 */
	void saveUserWeixin(String userCode, String openId);

	/**
	 * 官网保存租户用户
	 * 
	 * @param user
	 */
	ObjectResponse<UserBaseVO> saveTenantUser(UserBaseVO user);
	
}
