package com.yyjz.icop.usercenter.service;

import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.usercenter.vo.UserWeChatVO;

/**
 * 微信绑定接口
 * @author Administrator
 * @time 20180328
 */
public interface IUserWeChatService{
	
	/**
	 * 通过用户编码获取绑定信息
	 * @param userCode
	 * @return
	 */
	public UserWeChatVO getUserWCByUserCode(String userCode);
	
	/**
	 * 用户与公众号绑定：若已与其他公众号绑定，则修改openid；否则直接绑定
	 * @return
	 */
	public JSONObject bindWeChat(JSONObject reqJson);
	
	/**
	 * 用户与公众号解绑定
	 * @return
	 */
	public JSONObject unBindWeChat(String openId);
	
	/**
	 * 根据用户openid获取绑定信息
	 * @param openId
	 * @return
	 */
	public JSONObject bingInfo(String openId);
	
	/**
	 * 根据usercode获取绑定微信openid
	 * @param userCode
	 * @return
	 */
	public JSONObject weChatInfo(String userCode);

	/**
	 * 关联用户微信号
	 * 
	 * @param userId
	 * @param openId
	 */
	public void saveUserOpenId(String userId,String openId);
}
