/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.carousel.service.impl;

import com.yyjz.icop.carousel.entity.CarouselWidgetCustomEntity;
import com.yyjz.icop.carousel.repository.CarouselWidgetCustomDao;
import com.yyjz.icop.carousel.service.ICarouselWidgetCustomService;
import com.yyjz.icop.carousel.vo.CarouselWidgetCustomVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CarouselWidgetCustomServiceImpl
implements ICarouselWidgetCustomService {
    @Autowired
    private CarouselWidgetCustomDao carouselWidgetCustomDao;

    public void save(CarouselWidgetCustomVO vo) {
        this.carouselWidgetCustomDao.deleteByCarouselIdAndUserId(vo.getCarouselId(), vo.getUserId());
        CarouselWidgetCustomEntity entity = new CarouselWidgetCustomEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        this.carouselWidgetCustomDao.save((Object)entity);
    }

    @Transactional(readOnly=true)
    public List<String> queryWidgetIdsByCarouseIdAndUserId(String carouseId, String userId) {
        String widgetIdsStr;
        CarouselWidgetCustomEntity entity = this.carouselWidgetCustomDao.getByCarouselIdAndUserId(carouseId, userId);
        ArrayList<String> results = new ArrayList<String>();
        if (entity != null && StringUtils.isNotBlank((String)(widgetIdsStr = entity.getWidgetIds()))) {
            String[] widgetIds = widgetIdsStr.split(",");
            results.addAll(Arrays.asList(widgetIds));
        }
        return results;
    }
}

