/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.carousel.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.carousel.entity.CarouselWidgetEntity;
import com.yyjz.icop.carousel.repository.CarouselWidgetDao;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.carousel.vo.CarouselWidgetVO;
import com.yyjz.icop.permission.app.service.IAppGroupService;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.menu.vo.AppMenuVO;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springside.modules.nosql.redis.JedisTemplate;
import uap.web.utils.PropertyUtil;

@Service(value="carouselWidgetService")
public class CarouselWidgetServiceImpl
implements ICarouselWidgetService {
    private static final String isPublic = PropertyUtil.getPropertyByKey((String)"ccs.cloud.status");
    private static final String YONYOU_TENANT = "global";
    @Autowired
    private CarouselWidgetDao dao;
    @Autowired
    private WidgetXDao widgetXDao;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    private IAppGroupService appGroupService;

    public void clearCarouselCache(String carouselId) {
        List<String> ids = this.dao.findWidgetIdsByCarouselId(carouselId);
        if (CollectionUtils.isNotEmpty(ids)) {
            String key = "carousel_" + StringUtils.join((Object[])ids.toArray(new String[ids.size()]), (String)"_");
            this.jedisTemplate.del(new String[]{key});
        }
    }

    @Transactional
    public CarouselWidgetVO save(CarouselWidgetVO vo) throws Exception {
        Integer maxtag = this.dao.findMaxTagByCarouselId(vo.getCarouselId());
        if (maxtag == null) {
            maxtag = 0;
        }
        for (int i = 0; i < vo.getWidgetIds().size(); ++i) {
            maxtag = maxtag + 1;
            CarouselWidgetEntity c = new CarouselWidgetEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)c));
            c.setTenantId(InvocationInfoProxy.getTenantid());
            c.setWidgetId((String)vo.getWidgetIds().get(i));
            c.setTag(maxtag);
            c = (CarouselWidgetEntity)((Object)this.dao.save((Object)c));
        }
        return vo;
    }

    @Transactional
    public void del(String carouselId, String widgetId) throws Exception {
        this.dao.delWidgetByCarouselId(carouselId, widgetId);
    }

    public List<WidgetVO> findWidgetByCarouselId(String carouselId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ").append(" \tt.id, ").append(" \tt.NAME, ").append(" \tt.descr, ").append(" \tt.category, ").append(" \tt.wtype, ").append(" \tt.widget_type, ").append(" \tt.widget_property, ").append(" \tt.url, ").append(" \tt.url_text, ").append(" \tt.height, ").append(" \tt.magnet_type, ").append(" \tt.pk_widget, ").append(" \tt.isenable, ").append(" \tt.system, ").append(" \tt.tenant, ").append(" \tt.ctime, ").append(" \tt.cnf, ").append(" \tt.modifytime, ").append(" \tt.setting, ").append(" \tt.ts, ").append(" \tt.dr, ").append(" \tt.tenant_id, ").append(" \tt.pk_app_menu  ").append(" FROM ").append(" \tpt_widget t, ").append(" \tpt_carousel_widget p  ").append(" WHERE ").append(" \tt.dr = 0  ").append(" \tAND p.dr = 0  ").append(" \tAND carousel_id = ?  ").append(" \tAND t.tenant_id = ?  ").append(" \tAND t.pk_widget = p.widget_id ").append(" order by p.tag");
        String tenantId = "";
        tenantId = "public".equals(isPublic) ? YONYOU_TENANT : InvocationInfoProxy.getTenantid();
        return this.jdbcTemplate.query(sql.toString(), (RowMapper)new RowMapper<WidgetVO>(){

            public WidgetVO mapRow(ResultSet rs, int rowNum) throws SQLException {
                WidgetVO widgetVO = new WidgetVO();
                widgetVO.setId(rs.getString("id"));
                widgetVO.setName(rs.getString("name"));
                widgetVO.setDescr(rs.getString("descr"));
                widgetVO.setCategory(rs.getString("category"));
                widgetVO.setWtype(rs.getString("wtype"));
                widgetVO.setType(rs.getString("widget_type"));
                widgetVO.setProperty(rs.getString("widget_property"));
                widgetVO.setUrl(rs.getString("url"));
                widgetVO.setUrlText(rs.getString("url_text"));
                widgetVO.setHeight(Integer.valueOf(rs.getInt("height")));
                widgetVO.setMagnetType(rs.getString("magnet_type"));
                widgetVO.setWidgetId(rs.getString("pk_widget"));
                widgetVO.setIsenable(rs.getString("isenable"));
                widgetVO.setSystem(rs.getString("system"));
                widgetVO.setTenant(rs.getString("tenant"));
                widgetVO.setCtime(rs.getTime("ctime") != null ? new Date(rs.getTime("ctime").getTime()) : null);
                widgetVO.setCnf(rs.getString("cnf"));
                widgetVO.setModifytime(rs.getTime("modifytime") != null ? new Date(rs.getTime("modifytime").getTime()) : null);
                widgetVO.setSetting(rs.getString("setting"));
                widgetVO.setDr(rs.getInt("dr"));
                widgetVO.setTenant(rs.getString("tenant_id"));
                widgetVO.setPkAppMenu(rs.getString("pk_app_menu"));
                return widgetVO;
            }
        }, new Object[]{carouselId, tenantId});
    }

    @Transactional
    public int eidtTag(CarouselWidgetVO vo) {
        CarouselWidgetEntity entity = this.dao.findWidgetByCarouselId(vo.getCarouselId(), vo.getWidgetId());
        if (entity != null) {
            Integer tag = entity.getTag();
            if (vo.getType() == 0) {
                CarouselWidgetEntity upentity = this.dao.getUpWidgetById(vo.getCarouselId(), entity.getId());
                if (upentity != null) {
                    entity.setTag(upentity.getTag());
                    upentity.setTag(tag);
                    this.dao.save((Object)entity);
                    this.dao.save((Object)upentity);
                    return 0;
                }
                return 1;
            }
            CarouselWidgetEntity nextentity = this.dao.getNextWidgetById(vo.getCarouselId(), entity.getId());
            if (nextentity != null) {
                entity.setTag(nextentity.getTag());
                nextentity.setTag(tag);
                this.dao.save((Object)entity);
                this.dao.save((Object)nextentity);
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public List<WidgetVO> findAllByProperties(String carouselId, String searchText, String magnetType, String category) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("select pw.id, pw.pk_widget widgetId, pw.name, pw.magnet_type magnetType, pw.category, pw.pk_app_menu pkAppMenu ").append(" from pt_widget pw ").append(" inner join ( select widget_id,tag from pt_carousel_widget").append(" where carousel_id = ? and dr = 0) pcw on pw.pk_widget = pcw.widget_id ").append(" where pw.dr = 0 ");
        params.add(carouselId);
        if (StringUtils.isNotBlank((CharSequence)magnetType)) {
            sql.append(" and pw.magnet_type = ?");
            params.add(magnetType);
        }
        if (StringUtils.isNotBlank((CharSequence)category)) {
            StringBuffer appMenuIdsStr = null;
            List<String> categorys = new ArrayList<String>();
            categorys.add(category);
            categorys = this.appGroupService.getChildrenIdsByGroupIds(categorys);
            List appMenuIds = this.appMenuService.findAppMenuIdsByGroupIds(new HashSet(categorys));
            appMenuIdsStr = new StringBuffer();
            for (String id : appMenuIds) {
                appMenuIdsStr.append("'").append(id).append("',");
            }
            appMenuIdsStr.append("'-1'");
            sql.append(" and pw.pk_app_menu in (").append(appMenuIdsStr).append(") ");
        }
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            sql.append(" and (pw.id like CONCAT('%',?,'%') or pw.`name` like CONCAT('%',?,'%')) ");
            params.add(searchText);
            params.add(searchText);
        }
        sql.append(" order by pcw.tag");
        List resp = this.jdbcTemplate.query(sql.toString(), params.toArray(), (RowMapper)BeanPropertyRowMapper.newInstance(WidgetVO.class));
        if (CollectionUtils.isNotEmpty((Collection)resp)) {
            ArrayList<String> appMenuIds = new ArrayList<String>();
            for (WidgetVO v : resp) {
                appMenuIds.add(v.getPkAppMenu());
            }
            this.loadWidgetCategory(resp, appMenuIds);
        }
        return resp;
    }

    public void loadWidgetCategory(List<WidgetVO> vos, List<String> pkAppMenuIds) {
        Map appMenuVOs;
        if (CollectionUtils.isEmpty(pkAppMenuIds)) {
            for (WidgetVO vo : vos) {
                pkAppMenuIds.add(vo.getPkAppMenu());
            }
        }
        if (MapUtils.isNotEmpty((Map)(appMenuVOs = this.appMenuService.getAppMenuMapByIds(pkAppMenuIds)))) {
            for (WidgetVO v : vos) {
                if (null == appMenuVOs.get(v.getPkAppMenu())) continue;
                v.setCategory(((AppMenuVO)appMenuVOs.get(v.getPkAppMenu())).getCategory());
            }
        }
    }

    public List<WidgetVO> findWidgetByCarouselId(String carouselId, String roleId) {
        List appMenuIds = this.appMenuService.findMenuIdsByRoleId(roleId);
        if (CollectionUtils.isEmpty((Collection)appMenuIds)) {
            return null;
        }
        List<String> list = this.dao.findWidgetIdsByCarouselId(carouselId, appMenuIds);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<WidgetVO> vos = new ArrayList<WidgetVO>();
        if (list != null && list.size() > 0) {
            WidgetVO v = null;
            for (String id : list) {
                WidgetEntity e = (WidgetEntity)this.widgetXDao.findOne((Serializable)((Object)id));
                if (e == null) continue;
                v = new WidgetVO();
                BeanUtils.copyProperties((Object)e, (Object)v);
                vos.add(v);
            }
        }
        return vos;
    }

    @Transactional
    public void batchDel(String carouselId, List<String> widgetIds) {
        this.dao.batchDel(carouselId, widgetIds);
    }
}

