/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.carousel.web;

import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.base.response.PagableResponse;
import com.yyjz.icop.base.response.ReturnCode;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.base.utils.DESUtils;
import com.yyjz.icop.carousel.service.ICarouselService;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.carousel.vo.CarouselVO;
import com.yyjz.icop.layout.vo.RolesVO;
import com.yyjz.icop.orgcenter.company.service.ICompanyService;
import com.yyjz.icop.permission.partyorg.service.IPartyOrgService;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import iuap.portal.web.BaseController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.nosql.redis.JedisTemplate;

@Controller
@RequestMapping(value={"/carousel"})
public class CarouselController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(CarouselController.class);
    @Autowired
    private ICarouselService carouselService;
    @Autowired
    private ICarouselWidgetService carouselWidgetService;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IPartyOrgService partyOrgService;

    @ResponseBody
    @RequestMapping(value={"saveCarousel"}, method={RequestMethod.POST})
    public SimpleResponse saveCarousel(@RequestBody CarouselVO vo, HttpServletRequest request) {
        LOG.error("\u4fdd\u5b58\u8f6e\u64adVO[{}]", (Object)vo.toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            List vos = this.carouselService.findCarouselByCode(vo.getCarouselCode());
            if (vos != null && vos.size() > 0 && !((CarouselVO)vos.get(0)).getId().equals(vo.getId())) {
                sim.setCode(false);
                sim.setMsg("\u8f6e\u64ad\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
                return sim;
            }
            this.carouselService.save(vo, request);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error("\u8f6e\u64ad\u4fdd\u5b58\u5931\u8d25[{}]", (Object)e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @ResponseBody
    @RequestMapping(value={"saveCarouselNew"}, method={RequestMethod.POST})
    public SimpleResponse saveCarouselNew(@RequestBody CarouselVO vo, HttpServletRequest request) {
        LOG.error("\u4fdd\u5b58\u5c0f\u5e03\u5c40VO[{}]", (Object)vo.toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            List vos = this.carouselService.findCarouselByCode(vo.getCarouselCode());
            if (vos != null && vos.size() > 0 && !((CarouselVO)vos.get(0)).getId().equals(vo.getId())) {
                sim.setCode(false);
                sim.setMsg("\u5c0f\u5e03\u5c40\u7f16\u7801\u4e0d\u80fd\u91cd\u590d");
                return sim;
            }
            this.carouselService.save(vo, request);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error("\u5c0f\u5e03\u5c40\u4fdd\u5b58\u5931\u8d25[{}]", (Object)e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @ResponseBody
    @RequestMapping(value={"delCarousel"}, method={RequestMethod.DELETE})
    public SimpleResponse delCarousel(@RequestBody CarouselVO vo) {
        LOG.error("\u5220\u9664\u8f6e\u64adVO[{}]", (Object)vo.toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            ArrayList<String> carouselId = new ArrayList<String>();
            carouselId.add(vo.getId());
            return this.carouselService.batchDelCarousel(carouselId);
        }
        catch (Exception e) {
            LOG.error("\u8f6e\u64ad\u5220\u9664\u5931\u8d25[{}]", (Object)e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
            return sim;
        }
    }

    @RequestMapping(path={"findCarouseByRoleId"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectResponse<List<CarouselVO>> findCarouseByRoleId(@RequestParam(value="roleId", required=false) String roleId) {
        LOG.error(" roleId:[{}]", (Object)roleId);
        ObjectResponse sim = new ObjectResponse();
        try {
            List vos = this.carouselService.findCarouselByRoleId(roleId);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)vos);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(path={"findCarouseByCompanyId"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectResponse<List<CarouselVO>> findCarouseByCompanyId(@RequestParam(value="companyId", required=false) String companyId) {
        LOG.error(" companyId:[{}]", (Object)companyId);
        ObjectResponse sim = new ObjectResponse();
        try {
            List vos = this.carouselService.findCarouselByRoleId(companyId);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)vos);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(path={"page"}, method={RequestMethod.GET})
    @ResponseBody
    public PagableResponse<CarouselVO> page(@RequestParam(value="searchText", required=false) String param, @RequestParam(defaultValue="0") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false, value="companyId") String companyId) {
        PagableResponse response = new PagableResponse();
        response.setPageNumber(Integer.valueOf(pageNumber == 0 ? 1 : pageNumber));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest pageRequest = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        try {
            Page bos = this.carouselService.page(pageRequest, param, companyId);
            response.setCount(Long.valueOf(bos.getTotalElements()));
            response.setList(bos.getContent());
            response.setCode(ReturnCode.SUCCESS);
            response.setMsg("\u64cd\u4f5c\u6210\u529f\uff01");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(ReturnCode.FAILURE);
            response.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            return response;
        }
    }

    @RequestMapping(path={"pageByCompantId"}, method={RequestMethod.GET})
    @ResponseBody
    public PagableResponse<CarouselVO> pageByCompantId(@RequestParam(value="searchText", required=false) String param, @RequestParam(defaultValue="0") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false, value="companyId") String companyId, @RequestParam(required=false, value="carouselType") String carouselType, @RequestParam(required=true, value="layoutId") String layoutId, @RequestParam(defaultValue="1") String orgType) {
        PagableResponse response = new PagableResponse();
        response.setPageNumber(Integer.valueOf(pageNumber == 0 ? 1 : pageNumber));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest pageRequest = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        try {
            List companyIds = null;
            if ("1".equals(orgType)) {
                companyIds = this.companyService.queryAllParent(companyId);
            } else if ("2".equals(orgType)) {
                companyIds = this.partyOrgService.getParentIdsById(companyId);
            }
            if (CollectionUtils.isNotEmpty((Collection)companyIds)) {
                Page bos = this.carouselService.pageByCompanyIds(pageRequest, param, companyIds, carouselType, layoutId);
                response.setCount(Long.valueOf(bos.getTotalElements()));
                response.setList(bos.getContent());
                response.setCode(ReturnCode.SUCCESS);
                response.setMsg("\u64cd\u4f5c\u6210\u529f\uff01");
            } else {
                response.setCode(ReturnCode.FAILURE);
                response.setMsg("\u5bf9\u5e94\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01");
            }
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(ReturnCode.FAILURE);
            response.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            return response;
        }
    }

    @RequestMapping(path={"/getRolesByCarouselId"}, method={RequestMethod.GET})
    @ResponseBody
    public PagableResponse<RolesVO> getRolesByCarouselId(@RequestParam(value="searchText", required=false) String param, @RequestParam(defaultValue="0") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false, value="carouselId") String carouselId) {
        PagableResponse response = new PagableResponse();
        response.setPageNumber(Integer.valueOf(pageNumber == 0 ? 1 : pageNumber));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest pageRequest = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        try {
            List bos = this.carouselService.carouselRoleIds(param, carouselId);
            response.setCount(Long.valueOf(Long.parseLong(String.valueOf(bos.size()))));
            response.setList(bos);
            response.setCode(ReturnCode.SUCCESS);
            response.setMsg("\u64cd\u4f5c\u6210\u529f\uff01");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(ReturnCode.FAILURE);
            response.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            return response;
        }
    }

    @RequestMapping(value={"delCarouselRoles"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Object delCarouselRoles(@RequestBody CarouselVO vo) {
        SimpleResponse sim = new SimpleResponse();
        try {
            this.carouselService.delCarouselRoles(vo);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return sim;
    }

    @RequestMapping(path={"clearCache"}, method={RequestMethod.GET})
    @ResponseBody
    public SimpleResponse clearCache(@RequestParam(value="carouselId", required=false) String carouselId) {
        LOG.error(" carouselId:[{}]", (Object)carouselId);
        SimpleResponse sim = new SimpleResponse();
        try {
            List widgetList = this.carouselWidgetService.findWidgetByCarouselId(carouselId);
            if (widgetList != null && widgetList.size() > 0) {
                String widgetIds = "";
                for (WidgetVO widgetVo : widgetList) {
                    widgetIds = widgetIds + widgetVo.getWidgetId() + "_";
                }
                String key = "carousel_" + carouselId + widgetIds.substring(0, widgetIds.length() - 1);
                this.jedisTemplate.del(new String[]{DESUtils.encrypt((String)key)});
            }
            sim.setMsg("\u5237\u65b0\u6210\u529f");
            sim.setCode(true);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u5237\u65b0\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(value={"load/{carouselId}"}, method={RequestMethod.GET, RequestMethod.POST})
    public void loadCarousel(@PathVariable(value="carouselId") String carouselId, HttpServletResponse response) {
        response.setContentType("application/xhtml+xml;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            this.carouselService.findCarouselWidget(carouselId, response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @ResponseBody
    @RequestMapping(value={"batchDelCarousel"}, method={RequestMethod.DELETE})
    public SimpleResponse batchDelCarousel(@RequestBody List<String> carouselIds) {
        SimpleResponse resp = new SimpleResponse();
        LOG.error("\u6279\u91cf\u5220\u9664\u8f6e\u64ad[{}]", carouselIds);
        try {
            return this.carouselService.batchDelCarousel(carouselIds);
        }
        catch (Exception e) {
            LOG.error("\u6279\u91cf\u8f6e\u64ad\u5220\u9664\u5931\u8d25[{}]", (Object)e.getMessage());
            resp.setCode(false);
            resp.setMsg("\u64cd\u4f5c\u5931\u8d25");
            return resp;
        }
    }
}

