/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.carousel.web;

import com.yyjz.icop.base.response.ObjectResponse;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.carousel.service.ICarouselWidgetService;
import com.yyjz.icop.carousel.vo.CarouselWidgetVO;
import com.yyjz.icop.carousel.web.bo.CarouselWidgetBO;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import iuap.portal.web.BaseController;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/carouselWidget"})
public class CarouselWidgetController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(CarouselWidgetController.class);
    @Autowired
    private ICarouselWidgetService carouselWidgetService;

    @ResponseBody
    @RequestMapping(value={"saveCarouselWidget"}, method={RequestMethod.POST})
    public SimpleResponse saveCarouselWidget(@RequestBody CarouselWidgetBO bo) {
        LOG.debug("\u4fdd\u5b58\u8f6e\u64ad\u5c0f\u90e8\u4ef6BO[{}]", (Object)((Object)((Object)bo)).toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            this.carouselWidgetService.save((CarouselWidgetVO)bo);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error("\u8f6e\u64ad\u5c0f\u90e8\u4ef6\u4fdd\u5b58\u5931\u8d25[{}]", (Object)e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @ResponseBody
    @RequestMapping(value={"editCarouselWidgetTag"}, method={RequestMethod.POST})
    public SimpleResponse editCarouselWidgetTag(@RequestBody CarouselWidgetBO vo) {
        LOG.debug("\u4fee\u6539\u8f6e\u64ad\u5c0f\u90e8\u4ef6\u6392\u5e8fBO[{}]", (Object)((Object)((Object)vo)).toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            int isflag = this.carouselWidgetService.eidtTag((CarouselWidgetVO)vo);
            if (isflag == 0) {
                sim.setCode(true);
                sim.setMsg("\u64cd\u4f5c\u6210\u529f");
            } else if (isflag == 1) {
                sim.setCode(true);
                sim.setMsg("\u5df2\u7ecf\u6700\u4e0a\u7ea7\u4e86");
            } else if (isflag == 2) {
                sim.setCode(true);
                sim.setMsg("\u5df2\u7ecf\u6700\u4e0b\u7ea7\u4e86");
            } else {
                sim.setCode(false);
                sim.setMsg("\u6570\u636e\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e) {
            LOG.error("\u8f6e\u64ad\u5c0f\u90e8\u4ef6\u6392\u5e8f\u4fee\u6539\u5931\u8d25[{}]", (Object)e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @ResponseBody
    @RequestMapping(value={"delCarouselWidget"}, method={RequestMethod.DELETE})
    public SimpleResponse delCarousel(@RequestBody CarouselWidgetBO bo) {
        LOG.debug("\u5220\u9664\u8f6e\u64ad\u5c0f\u90e8\u4ef6BO[{}]", (Object)((Object)((Object)bo)).toString());
        SimpleResponse sim = new SimpleResponse();
        try {
            this.carouselWidgetService.del(bo.getCarouselId(), bo.getWidgetId());
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error("\u8f6e\u64ad\u5c0f\u90e8\u4ef6\u5220\u9664\u5931\u8d25[{}]", (Object)e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(path={"findWidgetByCarouseId"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectResponse<List<WidgetVO>> findWidgetByCarouseId(@RequestParam(value="carouselId", required=false) String carouselId) {
        LOG.debug(" carouselId:[{}]", (Object)carouselId);
        ObjectResponse sim = new ObjectResponse();
        try {
            List vos = this.carouselWidgetService.findWidgetByCarouselId(carouselId);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)vos);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(path={"findWidgetByCarouseIdNew"}, method={RequestMethod.GET})
    @ResponseBody
    public ObjectResponse<List<WidgetVO>> findWidgetByCarouseIdNew(@RequestParam(value="carouselId", required=false) String carouselId, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="magnetType", required=false) String magnetType, @RequestParam(value="category", required=false) String category) {
        LOG.debug(" carouselId:[{}]", (Object)carouselId);
        ObjectResponse sim = new ObjectResponse();
        try {
            if ("all".equals(magnetType)) {
                magnetType = null;
            }
            if ("all".equals(category)) {
                category = null;
            }
            List vos = this.carouselWidgetService.findAllByProperties(carouselId, searchText, magnetType, category);
            sim.setCode(true);
            sim.setMsg("\u67e5\u8be2\u6210\u529f");
            sim.setData((Object)vos);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @ResponseBody
    @RequestMapping(value={"batchDelCarouselWidget"}, method={RequestMethod.DELETE})
    public SimpleResponse delCarousel(@RequestBody Map<String, Object> delParam) {
        String carouselId = null;
        List widgetIds = null;
        SimpleResponse sim = new SimpleResponse();
        if (null != delParam) {
            carouselId = (String)delParam.get("carouselId");
            widgetIds = (List)delParam.get("widgetIds");
        }
        LOG.debug("\u6279\u91cf\u5220\u9664\u8f6e\u64ad\u5c0f\u90e8\u4ef6[carouselId-{},widgetIds-{}]", (Object)carouselId, widgetIds);
        if (StringUtils.isNotBlank((CharSequence)carouselId) && CollectionUtils.isNotEmpty((Collection)widgetIds)) {
            try {
                this.carouselWidgetService.batchDel(carouselId, widgetIds);
                sim.setCode(true);
                sim.setMsg("\u64cd\u4f5c\u6210\u529f");
            }
            catch (Exception e) {
                LOG.error("\u8f6e\u64ad\u5c0f\u90e8\u4ef6\u5220\u9664\u5931\u8d25[{}]", (Object)e.getMessage());
                sim.setCode(false);
                sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
                e.printStackTrace();
            }
        } else {
            LOG.debug("\u6279\u91cf\u5220\u9664\u8f6e\u64ad\u5c0f\u90e8\u4ef6\u5931\u8d25[carouselId-{},widgetIds-{}]", (Object)carouselId, (Object)widgetIds);
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return sim;
    }
}

