/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.context.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.context.bo.RoleBO;
import com.yyjz.icop.context.bo.UserRoleOrderBO;
import com.yyjz.icop.context.entity.UserRoleOrderEntity;
import com.yyjz.icop.context.repository.UserRoleOrderDao;
import com.yyjz.icop.context.service.WorkbenchAppService;
import com.yyjz.icop.permission.app.service.IAppService;
import com.yyjz.icop.permission.app.vo.AppVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.menu.vo.AppMenuVO;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import com.yyjz.icop.widgetx.entity.WidgetEntity;
import com.yyjz.icop.widgetx.repository.WidgetXDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WorkbenchAppServiceImpl
implements WorkbenchAppService {
    private static final String CURRENT_USER_ROLE_LIST = "CURRENT_USER_ROLE_LIST";
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRoleOrderDao userRoleOrderDao;
    @Autowired
    private WidgetXDao widgetXDao;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    private RedisTemplate<String, Object> jdkRedisTemplate;

    @Override
    public List<RoleBO> findRolesByUserAndCompanyId(String userId, String companyId) {
        List roles = this.roleService.findRolesByUserAndCompanyId(userId, companyId);
        return this.sortRoles(userId, companyId, roles);
    }

    @Override
    public List<RoleBO> sortRoles(String userId, String companyId, List<RoleVO> roles) {
        ArrayList<RoleBO> orderedRoles = null;
        List<UserRoleOrderEntity> orders = StringUtils.isNotBlank((CharSequence)companyId) ? this.userRoleOrderDao.findByUserIdAndCompanyId(userId, companyId) : this.userRoleOrderDao.findByUserId(userId);
        String selectedRole = null;
        if (!orders.isEmpty()) {
            UserRoleOrderEntity userRoleOrderEntity = orders.get(0);
            String roleIdsStr = userRoleOrderEntity.getRoleIds();
            selectedRole = userRoleOrderEntity.getSelectedRole();
            if (StringUtils.isNotBlank((CharSequence)roleIdsStr)) {
                String[] roleIds = roleIdsStr.split(",");
                HashMap<String, RoleBO> roleVOMap = new HashMap<String, RoleBO>();
                for (RoleVO roleVO : roles) {
                    RoleBO bo = new RoleBO();
                    BeanUtils.copyProperties((Object)roleVO, (Object)((Object)bo));
                    roleVOMap.put(roleVO.getId(), bo);
                }
                orderedRoles = new ArrayList();
                for (String roleId : roleIds) {
                    RoleBO roleBO = (RoleBO)((Object)roleVOMap.get(roleId));
                    if (roleBO == null) continue;
                    orderedRoles.add(roleBO);
                    roleVOMap.remove(roleId);
                }
                if (!roleVOMap.isEmpty()) {
                    for (Map.Entry entry : roleVOMap.entrySet()) {
                        orderedRoles.add((RoleBO)((Object)entry.getValue()));
                    }
                }
                for (int i = 0; i < orderedRoles.size(); ++i) {
                    RoleBO roleBO = (RoleBO)((Object)orderedRoles.get(i));
                    if (!roleBO.getId().equals(selectedRole)) continue;
                    roleBO.setSelected(true);
                    break;
                }
                return orderedRoles;
            }
        }
        orderedRoles = new ArrayList<RoleBO>();
        for (int i = 0; i < roles.size(); ++i) {
            RoleBO bo = new RoleBO();
            BeanUtils.copyProperties((Object)roles.get(i), (Object)((Object)bo));
            if (bo.getId().equals(selectedRole)) {
                bo.setSelected(true);
            }
            orderedRoles.add(bo);
        }
        return orderedRoles;
    }

    @Override
    public List<RoleBO> findRolesByUserId(String userId) {
        List roleVOS = this.roleService.findAllRolesByUserId(userId);
        return this.sortRoles(userId, null, roleVOS);
    }

    @Override
    @Transactional
    public String saveUserRoleOrder(UserRoleOrderBO bo) {
        String userId = InvocationInfoProxy.getUserid();
        List<UserRoleOrderEntity> userRoleOrders = this.userRoleOrderDao.findByUserId(userId);
        if (!userRoleOrders.isEmpty()) {
            bo.setSelectedRole(userRoleOrders.get(0).getSelectedRole());
        }
        this.userRoleOrderDao.deleteAllByUserId(userId);
        UserRoleOrderEntity entity = new UserRoleOrderEntity();
        BeanUtils.copyProperties((Object)bo, (Object)((Object)entity));
        entity.setUserId(userId);
        this.userRoleOrderDao.save((Object)entity);
        List roleVOS = this.roleService.findAllRolesByUserId(userId);
        List<RoleBO> roleBos = this.sortRoles(userId, null, roleVOS);
        this.jdkRedisTemplate.opsForValue().set((Object)("CURRENT_USER_ROLE_LIST:" + userId), roleBos);
        return bo.getId();
    }

    @Override
    public void saveSelectedRole(String roleId) {
        String userId = InvocationInfoProxy.getUserid();
        List<UserRoleOrderEntity> userRoleOrders = this.userRoleOrderDao.findByUserId(userId);
        if (userRoleOrders.isEmpty()) {
            UserRoleOrderEntity entity = new UserRoleOrderEntity();
            entity.setUserId(userId);
            entity.setSelectedRole(roleId);
            this.userRoleOrderDao.save((Object)entity);
        } else if (StringUtils.isNotBlank((CharSequence)roleId)) {
            this.userRoleOrderDao.updateSelectedRole(userId, roleId);
        }
    }

    @Override
    public AppMenuVO getAppMenu(String widgetCode, String appCode) {
        AppVO app;
        WidgetEntity widget;
        String pkAppMenu = null;
        if (StringUtils.isNotBlank((CharSequence)widgetCode) && (widget = this.widgetXDao.findById(widgetCode)) != null) {
            pkAppMenu = widget.getPkAppMenu();
        }
        if (pkAppMenu == null && StringUtils.isNotBlank((CharSequence)appCode) && (app = this.appService.findAppByCode(appCode)) != null) {
            pkAppMenu = app.getPkAppMenu();
        }
        if (StringUtils.isNotBlank(pkAppMenu)) {
            return this.appMenuService.findByPk(pkAppMenu);
        }
        return null;
    }
}

