/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.frequentmenu.service.iml;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.context.bo.RoleBO;
import com.yyjz.icop.context.service.WorkbenchAppService;
import com.yyjz.icop.frequentmenu.bo.FrequentMenuBO;
import com.yyjz.icop.frequentmenu.service.FrequentMenuService;
import com.yyjz.icop.permission.app.service.IAppService;
import com.yyjz.icop.permission.app.vo.AppVO;
import com.yyjz.icop.permission.menu.service.IAppMenuService;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FrequentMenuServiceImpl
implements FrequentMenuService {
    private static final String CURRENT_USER_ROLE_LIST = "CURRENT_USER_ROLE_LIST";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppMenuService appMenuService;
    @Autowired
    private RedisTemplate<String, Object> jdkRedisTemplate;
    @Autowired
    private WorkbenchAppService workbenchAppService;
    @Autowired
    private RoleService roleService;

    @Override
    @Transactional(readOnly=true)
    public List<AppVO> queryByUserId(String roleId) {
        List<FrequentMenuBO> frequentMenuBOS = this.getUserFrequentMenuBOS();
        ArrayList<String> appIds = new ArrayList<String>(10);
        Map authAppMap = this.appMenuService.queryAuthAppList(roleId);
        for (int i = 0; i < frequentMenuBOS.size(); ++i) {
            FrequentMenuBO bo = frequentMenuBOS.get(i);
            AppVO appVo = this.appService.findOne(bo.getAppId());
            if (appVo == null || authAppMap == null || !authAppMap.containsKey(appVo.getPkAppMenu())) continue;
            appIds.add(bo.getAppId());
            if (appIds.size() == 10) break;
        }
        List appVos = new ArrayList();
        HashMap<String, AppVO> appVOMap = new HashMap<String, AppVO>();
        if (!appIds.isEmpty()) {
            appVos = this.appService.getByIds(appIds);
            for (AppVO vo : appVos) {
                appVOMap.put(vo.getId(), vo);
            }
        }
        ArrayList<AppVO> orderedVos = new ArrayList<AppVO>();
        for (int i = 0; i < frequentMenuBOS.size(); ++i) {
            FrequentMenuBO frequentMenuBO = frequentMenuBOS.get(i);
            String appId = frequentMenuBO.getAppId();
            if (appVOMap.get(appId) == null) continue;
            orderedVos.add((AppVO)appVOMap.get(appId));
        }
        return orderedVos;
    }

    private List<FrequentMenuBO> getUserFrequentMenuBOS() {
        String userid = InvocationInfoProxy.getUserid();
        String sql = "SELECT t.id, t.app_id, t.user_id, t.app_url, t.count from pt_frequent_menu t where t.user_id = ? order by t.ts desc";
        return this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<FrequentMenuBO>(){

            public FrequentMenuBO mapRow(ResultSet rs, int rowNum) throws SQLException {
                FrequentMenuBO frequentMenuBO = new FrequentMenuBO();
                frequentMenuBO.setId(rs.getString("id"));
                frequentMenuBO.setAppId(rs.getString("app_id"));
                frequentMenuBO.setAppUrl(rs.getString("app_url"));
                frequentMenuBO.setUserId(rs.getString("user_id"));
                frequentMenuBO.setCount(rs.getInt("count"));
                return frequentMenuBO;
            }
        }, new Object[]{userid});
    }

    @Override
    public List<AppVO> query(String roleId) {
        ArrayList<AppVO> results = new ArrayList<AppVO>();
        String userId = InvocationInfoProxy.getUserid();
        List<FrequentMenuBO> frequentMenuBOS = this.getUserFrequentMenuBOS();
        List<Object> roleVoList = null;
        if (StringUtils.isBlank((CharSequence)roleId)) {
            roleVoList = (List)this.jdkRedisTemplate.opsForValue().get((Object)("CURRENT_USER_ROLE_LIST:" + userId));
            if (roleVoList == null || roleVoList.isEmpty()) {
                roleVoList = this.workbenchAppService.findRolesByUserId(userId);
            }
        } else {
            roleVoList = new ArrayList();
            RoleVO roleVo = this.roleService.findOneRole(roleId);
            RoleBO bo = new RoleBO();
            BeanUtils.copyProperties((Object)roleVo, (Object)((Object)bo));
            roleVoList.add((Object)bo);
        }
        if (roleVoList != null && roleVoList.size() > 0) {
            ArrayList<String> roleIds = new ArrayList<String>();
            for (int i = 0; i < roleVoList.size(); ++i) {
                roleIds.add(((RoleBO)((Object)roleVoList.get(i))).getId());
            }
            ArrayList<String> appIds = new ArrayList<String>();
            for (FrequentMenuBO bo : frequentMenuBOS) {
                appIds.add(bo.getAppId());
            }
            List appVos = this.appService.getByIds(appIds);
            HashMap<String, AppVO> appMap = new HashMap<String, AppVO>();
            if (appVos != null && appVos.size() > 0) {
                for (int i = 0; i < appVos.size(); ++i) {
                    AppVO appVO = (AppVO)appVos.get(i);
                    appMap.put(appVO.getId(), appVO);
                }
            }
            Map authAppMap = this.appMenuService.queryAuthAppList(roleIds);
            for (int i = 0; i < appIds.size(); ++i) {
                String appId = (String)appIds.get(i);
                AppVO appVO = (AppVO)appMap.get(appId);
                if (appVO != null && authAppMap.containsKey(appVO.getPkAppMenu())) {
                    results.add(appVO);
                }
                if (results.size() == 9) break;
            }
        }
        return results;
    }

    @Override
    public void save(String appId, String appUrl) {
        String userid = InvocationInfoProxy.getUserid();
        StringBuilder sql = new StringBuilder();
        sql.append(" DELETE t  ").append(" FROM ").append(" \tpt_frequent_menu t ").append(" \tINNER JOIN ( ").append(" SELECT ").append(" \tt.id  ").append(" FROM ").append(" \t( SELECT t.id FROM pt_frequent_menu t WHERE t.user_id = ? ORDER BY t.ts DESC LIMIT 9, 18446744073709551615 ) t UNION ALL ").append(" SELECT ").append(" \tid  ").append(" FROM ").append(" \tpt_frequent_menu fm  ").append(" WHERE ").append(" \tfm.app_id = ?  ").append(" \tAND fm.user_id = ?  ").append(" \t) a ON t.id = a.id ");
        this.jdbcTemplate.update(sql.toString(), new Object[]{userid, appId, userid});
        String insertSQL = "INSERT INTO pt_frequent_menu(id, user_id, app_id, count, app_url) VALUES (?, ?, ?, 1, ?)";
        this.jdbcTemplate.update(insertSQL, new Object[]{UUID.randomUUID().toString().replace("-", ""), userid, appId, appUrl});
    }
}

