/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layout.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.carousel.service.ICarouselService;
import com.yyjz.icop.layout.entity.LayoutRoleDesignEntity;
import com.yyjz.icop.layout.repository.LayoutRoleDesignDao;
import com.yyjz.icop.layout.service.ILayoutMgrService;
import com.yyjz.icop.layout.vo.LayoutRoleVO;
import com.yyjz.icop.layout.vo.LayoutVO;
import com.yyjz.icop.layout.vo.RolesVO;
import com.yyjz.icop.orgcenter.company.service.ICompanyService;
import com.yyjz.icop.orgcenter.company.vo.CompanyVO;
import com.yyjz.icop.permission.partyorg.service.IPartyOrgService;
import com.yyjz.icop.permission.partyorg.vo.PartyOrgVO;
import com.yyjz.icop.permission.role.service.IRoleAppBtnService;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleAppBtnVO;
import com.yyjz.icop.permission.role.vo.RoleAppVO;
import com.yyjz.icop.permission.role.vo.RoleVO;
import com.yyjz.icop.permission.widget.service.IRoleWidgetService;
import com.yyjz.icop.permission.widget.vo.RoleWidgetVO;
import iuap.portal.util.UUIDUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service(value="layoutMgrService")
@Transactional
public class LayoutMgrServiceImpl
implements ILayoutMgrService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private NamedParameterJdbcTemplate namedJdbcTemplate;
    private static String setting = "<div class=\"col-md-12 ui-grid\" id=\"widgetbox1\"><WidgetBox id=\"widgetbox1_t\"></WidgetBox></div>";
    @Autowired
    private LayoutRoleDesignDao dao;
    @Autowired
    private IPartyOrgService partyOrgService;
    @Autowired
    private ICarouselService carouselService;
    @Autowired
    private IRoleAppBtnService roleAppBtnService;
    @Autowired
    private IRoleWidgetService roleWidgetService;

    public String join() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO PT_LAYOUT(ID,PK_LAYOUT,NAME,TENANT,TEMPLATEID,RND,DR,TENANT_ID,CTIME,TS,MODIFYTIME,SYSTEM,ISENABLE,SETTING,CODE,COMPANY_ID,LAYOUT_TYPE)");
        sb.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sb.toString();
    }

    public void update(final LayoutVO vo) throws Exception {
        try {
            final String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String sql = "UPDATE PT_LAYOUT SET NAME=?,CODE=?,RND=?,modifytime=? WHERE ID=?";
            this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, vo.getLayoutName());
                    ps.setString(2, vo.getLayoutCode());
                    ps.setString(3, UUIDUtils.base58Uuid());
                    ps.setString(4, time);
                    ps.setString(5, vo.getId());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u4fee\u6539\u5e03\u5c40\u5931\u8d25" + e.getMessage());
        }
    }

    public void save(final LayoutVO vo) throws Exception {
        try {
            if (StringUtils.isBlank((CharSequence)vo.getId())) {
                final String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
                this.jdbcTemplate.update(this.join(), new PreparedStatementSetter(){

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, UUID.randomUUID().toString());
                        ps.setString(2, UUIDUtils.base58Uuid());
                        ps.setString(3, vo.getLayoutName());
                        ps.setString(4, InvocationInfoProxy.getTenantid());
                        ps.setString(5, "column12");
                        ps.setString(6, UUIDUtils.base58Uuid());
                        ps.setInt(7, 0);
                        ps.setString(8, InvocationInfoProxy.getTenantid());
                        ps.setString(9, time);
                        ps.setString(10, time);
                        ps.setString(11, time);
                        ps.setString(12, "icop");
                        ps.setString(13, "Y");
                        ps.setString(14, setting);
                        ps.setString(15, vo.getLayoutCode());
                        ps.setString(16, vo.getCompanyId());
                        ps.setInt(17, 2);
                    }
                });
            } else {
                this.update(vo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u4fdd\u5b58\u5e03\u5c40\u5931\u8d25" + e.getMessage());
        }
    }

    @Transactional
    public void del(final String id) throws Exception {
        try {
            this.jdbcTemplate.update("delete from pt_layout   where id=?", new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, id);
                }
            });
            this.jdbcTemplate.update("delete from sm_role_design   where layout_id=?", new PreparedStatementSetter(){

                public void setValues(PreparedStatement ps) throws SQLException {
                    ps.setString(1, id);
                }
            });
        }
        catch (Exception e) {
            throw new Exception();
        }
    }

    private Map<String, Object> setParam(PageRequest page, String param, List<String> ids, String layoutCode) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)param)) {
            obj.put("param", param);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            obj.put("ids", ids);
        }
        if (StringUtils.isNotBlank((CharSequence)layoutCode)) {
            obj.put("layoutCode", layoutCode);
        }
        if (page != null) {
            obj.put("offset", page.getOffset());
            obj.put("pageSize", page.getPageSize());
        }
        return obj;
    }

    private String joinSql(PageRequest page, String param, List<String> companyId, String layoutCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("select id,name layoutName,code layoutCode,company_id companyId,rnd from pt_layout where dr=0 and layout_type=2 ");
        if (StringUtils.isNotBlank((CharSequence)param)) {
            sb.append(" and (name LIKE concat('%',:param, '%') or code LIKE concat('%',:param, '%'))");
        }
        if (CollectionUtils.isNotEmpty(companyId)) {
            sb.append(" and  company_id in(:ids) ");
        }
        if (StringUtils.isNotBlank((CharSequence)layoutCode)) {
            sb.append(" and  code=:layoutCode ");
        }
        sb.append(" ORDER BY modifytime DESC ");
        if (page != null) {
            sb.append("limit :offset,:pageSize");
        }
        return sb.toString();
    }

    Long count(String param, List<String> companyId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from  ( ");
        sb.append(this.joinSql(null, param, companyId, null));
        sb.append(") r");
        return (Long)this.namedJdbcTemplate.queryForObject(sb.toString(), this.setParam(null, param, companyId, null), Long.class);
    }

    public Page<LayoutVO> list(PageRequest page, String param, String companyId, Integer orgType) {
        ArrayList<LayoutVO> vos = new ArrayList<LayoutVO>();
        List companyIds = new ArrayList();
        companyIds = orgType == 2 ? this.partyOrgService.getParentIdsById(companyId) : this.companyService.queryAllParent(companyId);
        Long count = this.count(param, companyIds);
        if (count > 0L) {
            List bos = this.namedJdbcTemplate.queryForList(this.joinSql(page, param, companyIds, null), this.setParam(page, param, companyIds, null));
            for (int i = 0; i < bos.size(); ++i) {
                LayoutVO v = new LayoutVO();
                try {
                    BeanUtils.populate((Object)v, (Map)((Map)bos.get(i)));
                    if (orgType == 2) {
                        PartyOrgVO pvo = this.partyOrgService.findBySourceId(v.getCompanyId());
                        if (pvo != null) {
                            v.setCompanyName(pvo.getName());
                        }
                    } else {
                        CompanyVO cvo = this.companyService.getCompany(v.getCompanyId());
                        if (cvo != null) {
                            v.setCompanyName(cvo.getCompanyShName());
                        }
                    }
                    vos.add(v);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return new PageImpl(vos, (Pageable)page, count.longValue());
    }

    public List<RolesVO> layoutRoleIds(String param, String layoutId, Integer orgType) {
        ArrayList<RolesVO> vos = new ArrayList<RolesVO>();
        List<String> ids = this.getRoleIdsByLayout(layoutId);
        try {
            if (CollectionUtils.isNotEmpty(ids)) {
                List roles = this.roleService.findOrgFunsRolesByLayout(param, ids);
                for (int i = 0; i < roles.size(); ++i) {
                    RolesVO vo = new RolesVO();
                    BeanUtils.copyProperties((Object)vo, roles.get(i));
                    LayoutRoleDesignEntity en = this.dao.findOneByLayoutId(layoutId, ((RoleVO)roles.get(i)).getId());
                    if (orgType == 2) {
                        PartyOrgVO pvo = this.partyOrgService.findBySourceId(en.getCompanyId());
                        if (pvo != null) {
                            vo.setBindCompanyName(pvo.getName());
                            vo.setBindCompanyId(en.getCompanyId());
                        }
                    } else {
                        CompanyVO cvo = this.companyService.getCompany(en.getCompanyId());
                        if (cvo != null) {
                            vo.setBindCompanyName(cvo.getCompanyShName());
                            vo.setBindCompanyId(en.getCompanyId());
                        }
                    }
                    vo.setBindTime(en.getCreationTimestamp().toString());
                    vos.add(vo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return vos;
        }
        return vos;
    }

    @Transactional
    public void delLayoutRoles(LayoutVO vo) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", vo.getId());
        map.put("ids", vo.getIds());
        String sql = "delete from sm_role_design   where layout_id=:id and role_id in(:ids)";
        this.namedJdbcTemplate.update(sql, map);
    }

    @Transactional
    public void saveLayoutRoles(LayoutVO vo) throws Exception {
        try {
            ArrayList<LayoutRoleDesignEntity> entitys = new ArrayList<LayoutRoleDesignEntity>();
            List<String> ids = this.getRoleIdsByLayout(vo.getId());
            for (int i = 0; i < vo.getIds().size(); ++i) {
                LayoutRoleDesignEntity e = new LayoutRoleDesignEntity();
                e.setLayoutId(vo.getId());
                e.setRoleId((String)vo.getIds().get(i));
                e.setCompanyId(vo.getCompanyId());
                e.setSort(i + 1);
                if (!CollectionUtils.isEmpty(ids) && ids.contains(e.getRoleId())) continue;
                entitys.add(e);
            }
            this.dao.save(entitys);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public List<String> getRoleIdsByLayout(String layoutId) {
        String sql = "select role_id from sm_role_design where layout_id=? and dr=0 ";
        List ids = this.jdbcTemplate.queryForList(sql, (Object[])new String[]{layoutId}, String.class);
        return ids;
    }

    @Deprecated
    public List<LayoutRoleVO> findByRoleIds(List<String> ids, String layoutId, String companyId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select id,role_id roleId,layout_id layoutId,company_id companyId");
        sb.append(",(select name from pt_layout where id=layout_id) layoutName");
        sb.append(" from sm_role_design where dr=0 and company_id!=:param");
        if (CollectionUtils.isNotEmpty(ids)) {
            sb.append(" and role_id in(:ids)");
        }
        if (StringUtils.isNotBlank((CharSequence)layoutId)) {
            sb.append(" and layout_id=:layoutCode");
        }
        List bos = this.namedJdbcTemplate.queryForList(sb.toString(), this.setParam(null, companyId, ids, layoutId));
        ArrayList<LayoutRoleVO> vos = null;
        if (CollectionUtils.isEmpty((Collection)bos)) {
            return null;
        }
        vos = new ArrayList<LayoutRoleVO>();
        for (int i = 0; i < bos.size(); ++i) {
            LayoutRoleVO vo = new LayoutRoleVO();
            try {
                BeanUtils.populate((Object)vo, (Map)((Map)bos.get(i)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            vos.add(vo);
        }
        return vos;
    }

    public List<LayoutVO> findByLayoutCode(String layoutCode) {
        List bos = this.namedJdbcTemplate.queryForList(this.joinSql(null, null, null, layoutCode), this.setParam(null, null, null, layoutCode));
        if (CollectionUtils.isEmpty((Collection)bos)) {
            return null;
        }
        ArrayList<LayoutVO> vos = new ArrayList<LayoutVO>();
        for (int i = 0; i < bos.size(); ++i) {
            LayoutVO vo = new LayoutVO();
            try {
                BeanUtils.populate((Object)vo, (Map)((Map)bos.get(i)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            vos.add(vo);
        }
        return vos;
    }

    public LayoutVO savefindByLayoutCode(String layoutCode, final String tenantId, String companyId, String companyName, String roleId) {
        LayoutVO vo = null;
        try {
            List bos = this.namedJdbcTemplate.queryForList("select * from pt_layout where dr=0 and layout_type=2 and code=:layoutCode and tenant_id='global'", this.setParam(null, null, null, layoutCode));
            if (bos != null && bos.size() > 0) {
                String time;
                final String templateid = (String)((Map)bos.get(0)).get("templateid");
                String setting = (String)((Map)bos.get(0)).get("setting");
                final String name = (String)((Map)bos.get(0)).get("name");
                String system = (String)((Map)bos.get(0)).get("system");
                String isenable = (String)((Map)bos.get(0)).get("isenable");
                String code = (String)((Map)bos.get(0)).get("code");
                String sql = "INSERT INTO PT_LAYOUT(ID,PK_LAYOUT,NAME,TENANT,TEMPLATEID,RND,DR,TENANT_ID,CTIME,TS,MODIFYTIME,SYSTEM,ISENABLE,SETTING,CODE,COMPANY_ID,LAYOUT_TYPE) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                final String id = UUID.randomUUID().toString();
                int num = this.jdbcTemplate.update(sql, new PreparedStatementSetter(time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()), system, isenable, setting, code, companyId){
                    final /* synthetic */ String val$time;
                    final /* synthetic */ String val$system;
                    final /* synthetic */ String val$isenable;
                    final /* synthetic */ String val$setting;
                    final /* synthetic */ String val$code;
                    final /* synthetic */ String val$companyId;
                    {
                        this.val$time = string5;
                        this.val$system = string6;
                        this.val$isenable = string7;
                        this.val$setting = string8;
                        this.val$code = string9;
                        this.val$companyId = string10;
                    }

                    public void setValues(PreparedStatement ps) throws SQLException {
                        ps.setString(1, id);
                        ps.setString(2, UUIDUtils.base58Uuid());
                        ps.setString(3, name);
                        ps.setString(4, tenantId);
                        ps.setString(5, templateid);
                        ps.setString(6, UUIDUtils.base58Uuid());
                        ps.setInt(7, 0);
                        ps.setString(8, tenantId);
                        ps.setString(9, this.val$time);
                        ps.setString(10, this.val$time);
                        ps.setString(11, this.val$time);
                        ps.setString(12, this.val$system);
                        ps.setString(13, this.val$isenable);
                        ps.setString(14, this.val$setting);
                        ps.setString(15, this.val$code);
                        ps.setString(16, this.val$companyId);
                        ps.setInt(17, 2);
                    }
                });
                if (num == 1) {
                    vo = new LayoutVO();
                    vo.setLayoutCode(code);
                    vo.setLayoutName(name);
                    vo.setId(id);
                    List list = this.carouselService.findCarouselByLayoutId((String)((Map)bos.get(0)).get("id"));
                    this.carouselService.batchSaveCarousel(list, id, tenantId, companyId, companyName, roleId);
                }
                return vo;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String savefindByRoleCode(String roleCode, String tenantId, String companyId) {
        try {
            RoleVO role = this.roleService.findOneRoleByCode(roleCode, Integer.valueOf(1), "global");
            if (role != null) {
                List app = this.roleAppBtnService.findRoleAppByRoleId(role.getId());
                List btn = this.roleAppBtnService.getAllRoleRecord(role.getId());
                List widget = this.roleWidgetService.findAllRoleWidgets(role.getId());
                RoleVO isflag = this.roleService.findOneRoleByCode(roleCode, Integer.valueOf(1), tenantId);
                if (isflag == null) {
                    role.setId(null);
                    role.setCreationTimestamp(new Timestamp(System.currentTimeMillis()));
                    role.setTenantId(tenantId);
                    role.setCompanyId(companyId);
                    role = this.roleService.addRole(role);
                } else {
                    role = isflag;
                }
                if (role != null) {
                    this.roleAppBtnService.deleteRoleAppBtnByRoleId(role.getId());
                    for (RoleAppVO vo : app) {
                        vo.setId(null);
                        vo.setCreationTimestamp(new Timestamp(System.currentTimeMillis()));
                        vo.setTenantId(tenantId);
                        vo.setRoleId(role.getId());
                        this.roleAppBtnService.saveRoleAppVO(vo);
                    }
                    this.roleAppBtnService.deleteRoleAppBtnByRoleId(role.getId());
                    for (RoleAppVO vo : btn) {
                        vo.setId(null);
                        vo.setCreationTimestamp(new Timestamp(System.currentTimeMillis()));
                        vo.setTenantId(tenantId);
                        vo.setRoleId(role.getId());
                        this.roleAppBtnService.save((RoleAppBtnVO)vo);
                    }
                    this.roleWidgetService.deleteByRoleId(role.getId());
                    for (RoleAppVO vo : widget) {
                        vo.setId(null);
                        vo.setCreationTimestamp(new Timestamp(System.currentTimeMillis()));
                        vo.setTenantId(tenantId);
                        vo.setRoleId(role.getId());
                        this.roleWidgetService.save((RoleWidgetVO)vo);
                    }
                    return role.getId();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<LayoutVO> getByCarouselIds(List<String> carouselIds) {
        ArrayList<LayoutVO> resp = new ArrayList();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT l.* FROM pt_layout l WHERE l.id IN ").append(" (SELECT DISTINCT(c.layout_id) from pt_carousel c WHERE c.id IN (");
        for (String id : carouselIds) {
            sql.append(" ?, ");
        }
        sql.append(" 0))");
        resp = this.jdbcTemplate.query(sql.toString(), carouselIds.toArray(), (RowMapper)new RowMapper<LayoutVO>(){

            public LayoutVO mapRow(ResultSet rs, int rowNum) throws SQLException {
                LayoutVO vo = new LayoutVO();
                vo.setId(rs.getString("id"));
                vo.setSetting(rs.getString("setting"));
                vo.setPkLayout(rs.getString("pk_layout"));
                vo.setLayoutName(rs.getString("name"));
                vo.setLayoutCode(rs.getString("code"));
                vo.setRnd(rs.getString("rnd"));
                vo.setCompanyId(rs.getString("company_id"));
                return vo;
            }
        });
        return resp;
    }

    public List<RolesVO> layoutRoleIds(String param, String layoutId, int orgType, String userType) {
        ArrayList<RolesVO> vos = new ArrayList<RolesVO>();
        List<String> ids = this.getRoleIdsByLayout(layoutId);
        try {
            if (CollectionUtils.isNotEmpty(ids)) {
                List roles = new ArrayList();
                roles = "1".equals(userType) ? this.roleService.findRolesByLayout(param, ids) : this.roleService.findOrgFunsRolesByLayout(param, ids);
                for (int i = 0; i < roles.size(); ++i) {
                    RolesVO vo = new RolesVO();
                    BeanUtils.copyProperties((Object)vo, roles.get(i));
                    LayoutRoleDesignEntity en = this.dao.findOneByLayoutId(layoutId, ((RoleVO)roles.get(i)).getId());
                    if (orgType == 2) {
                        PartyOrgVO pvo = this.partyOrgService.findBySourceId(en.getCompanyId());
                        if (pvo != null) {
                            vo.setBindCompanyName(pvo.getName());
                            vo.setBindCompanyId(en.getCompanyId());
                        }
                    } else {
                        CompanyVO cvo = this.companyService.getCompany(en.getCompanyId());
                        if (cvo != null) {
                            vo.setBindCompanyName(cvo.getCompanyShName());
                            vo.setBindCompanyId(en.getCompanyId());
                        }
                    }
                    vo.setBindTime(en.getCreationTimestamp().toString());
                    vos.add(vo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return vos;
        }
        return vos;
    }
}

