/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layout.web;

import com.yyjz.icop.base.response.PagableResponse;
import com.yyjz.icop.base.response.ReturnCode;
import com.yyjz.icop.base.response.SimpleResponse;
import com.yyjz.icop.carousel.service.ICarouselService;
import com.yyjz.icop.layout.service.ILayoutMgrService;
import com.yyjz.icop.layout.service.ILayoutRoleDesignService;
import com.yyjz.icop.layout.vo.LayoutRoleVO;
import com.yyjz.icop.layout.vo.LayoutVO;
import com.yyjz.icop.layout.vo.RolesVO;
import com.yyjz.icop.permission.role.service.RoleService;
import com.yyjz.icop.permission.role.vo.RoleVO;
import iuap.portal.web.BaseController;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/layoutMgr"})
public class LayoutMgrController
extends BaseController {
    @Autowired
    private ILayoutMgrService layoutMgrService;
    @Autowired
    private ILayoutRoleDesignService layoutRoleDesignService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ICarouselService carouselService;

    @RequestMapping(path={"/page"}, method={RequestMethod.GET})
    @ResponseBody
    public PagableResponse<LayoutVO> getPageableRole(@RequestParam(value="searchText", required=false) String param, @RequestParam(defaultValue="0") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false, value="companyId") String companyId, @RequestParam(required=false, value="orgType") int orgType) {
        PagableResponse response = new PagableResponse();
        response.setPageNumber(Integer.valueOf(pageNumber == 0 ? 1 : pageNumber));
        response.setPageSize(Integer.valueOf(pageSize));
        PageRequest pageRequest = new PageRequest(pageNumber - 1 < 0 ? 0 : pageNumber - 1, pageSize);
        try {
            Page bos = this.layoutMgrService.list(pageRequest, param, companyId, Integer.valueOf(orgType));
            response.setCount(Long.valueOf(bos.getTotalElements()));
            response.setList(bos.getContent());
            response.setCode(ReturnCode.SUCCESS);
            response.setMsg("\u83b7\u53d6\u5e03\u5c40\u4fe1\u606f\u6210\u529f\uff01");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(ReturnCode.FAILURE);
            response.setMsg("\u83b7\u53d6\u5e03\u5c40\u5931\u8d25\uff01");
            return response;
        }
    }

    @ResponseBody
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public SimpleResponse saveCarousel(@RequestBody LayoutVO vo) {
        SimpleResponse sim = new SimpleResponse();
        try {
            List vos = this.layoutMgrService.findByLayoutCode(vo.getLayoutCode());
            if (CollectionUtils.isNotEmpty((Collection)vos) && (StringUtils.isBlank((CharSequence)vo.getId()) || !vo.getId().equals(((LayoutVO)vos.get(0)).getId()))) {
                sim.setCode(false);
                sim.setMsg("\u7f16\u7801\u91cd\u590d");
                return sim;
            }
            this.layoutMgrService.save(vo);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(value={"delLayout"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Object delLayout(@RequestBody LayoutVO vo) {
        SimpleResponse sim = new SimpleResponse();
        try {
            List carouselList = this.carouselService.findCarouselByLayoutId(vo.getId());
            if (CollectionUtils.isNotEmpty((Collection)carouselList)) {
                sim.setCode(false);
                sim.setMsg("\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u5e03\u5c40\u4e0b\u5173\u8054\u6709\u5c0f\u5e03\u5c40\uff0c\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\u3002");
            } else {
                this.layoutMgrService.del(vo.getId());
                sim.setCode(true);
                sim.setMsg("\u64cd\u4f5c\u6210\u529f");
            }
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return sim;
    }

    @RequestMapping(path={"/getRolesByLayoutId"}, method={RequestMethod.GET})
    @ResponseBody
    public PagableResponse<RolesVO> getRolesByLayoutId(@RequestParam(value="searchText", required=false) String param, @RequestParam(defaultValue="0") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false, value="layoutId") String layoutId, @RequestParam(required=false, value="orgType") int orgType, @RequestParam(required=false, value="userType") String userType) {
        PagableResponse response = new PagableResponse();
        response.setPageNumber(Integer.valueOf(pageNumber == 0 ? 1 : pageNumber));
        response.setPageSize(Integer.valueOf(pageSize));
        try {
            if (StringUtils.isBlank((CharSequence)layoutId)) {
                response.setCount(Long.valueOf(0L));
                response.setList(null);
                response.setCode(ReturnCode.SUCCESS);
                response.setMsg("\u83b7\u53d6\u5e03\u5c40\u4fe1\u606f\u6210\u529f\uff01");
                return response;
            }
            List bos = this.layoutMgrService.layoutRoleIds(param, layoutId, orgType, userType);
            response.setCount(Long.valueOf(Long.parseLong(String.valueOf(bos.size()))));
            response.setList(bos);
            response.setCode(ReturnCode.SUCCESS);
            response.setMsg("\u83b7\u53d6\u5e03\u5c40\u4fe1\u606f\u6210\u529f\uff01");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setCode(ReturnCode.FAILURE);
            response.setMsg("\u83b7\u53d6\u5e03\u5c40\u5931\u8d25\uff01");
            return response;
        }
    }

    @RequestMapping(value={"delLayoutRoles"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Object delLayoutRoles(@RequestBody LayoutVO vo) {
        SimpleResponse sim = new SimpleResponse();
        try {
            if (!vo.getUserType().equals("1")) {
                List vos = this.layoutMgrService.findByRoleIds(vo.getIds(), vo.getId(), vo.getCompanyId());
                if (CollectionUtils.isNotEmpty((Collection)vos)) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < vos.size(); ++i) {
                        RoleVO roleVo = this.roleService.findOneRole(((LayoutRoleVO)vos.get(i)).getRoleId());
                        if (roleVo == null) continue;
                        sb.append("\u89d2\u8272[" + roleVo.getRoleName() + "]\u7684\u7ed1\u5b9a\u7ec4\u7ec7\u548c\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5339\u914d;\u8bf7\u91cd\u65b0\u9009\u62e9\u3002<br/>");
                    }
                    sim.setCode(false);
                    sim.setMsg(sb.toString());
                } else {
                    this.layoutMgrService.delLayoutRoles(vo);
                    sim.setCode(true);
                    sim.setMsg("\u64cd\u4f5c\u6210\u529f");
                }
            } else {
                this.layoutMgrService.delLayoutRoles(vo);
                sim.setCode(true);
                sim.setMsg("\u64cd\u4f5c\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return sim;
    }

    @ResponseBody
    @RequestMapping(value={"saveLayoutRoles"}, method={RequestMethod.POST})
    public SimpleResponse saveLayoutRoles(@RequestBody LayoutVO vo) {
        SimpleResponse sim = new SimpleResponse();
        StringBuilder sb = new StringBuilder();
        try {
            this.layoutMgrService.saveLayoutRoles(vo);
            sim.setCode(true);
            sb.append("\u64cd\u4f5c\u6210\u529f");
            sim.setMsg(sb.toString());
        }
        catch (Exception e) {
            sim.setCode(false);
            sim.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return sim;
    }

    @RequestMapping(value={"batchSave"}, method={RequestMethod.GET})
    @ResponseBody
    public Object batchSave(@RequestParam(defaultValue="fxb9slMa") String tenantId, @RequestParam(defaultValue="8aaaee4a60b664eb0160ca4c0e8200a5") String companyId, @RequestParam(defaultValue="cgs") String type) {
        SimpleResponse sim = new SimpleResponse();
        try {
            Map map = this.layoutRoleDesignService.saveRoleLayout(tenantId, companyId, type);
            sim.setCode(true);
            sim.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            sim.setCode(false);
            sim.setMsg("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
        }
        return sim;
    }
}

