/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layouttpl.web;

import com.alibaba.fastjson.JSONObject;
import com.yonyou.iuap.portal.base.web.Response;
import com.yyjz.icop.layouttpl.service.ILayoutTplService;
import com.yyjz.icop.widgetx.vo.WidgetVO;
import iuap.portal.entity.LayoutTemplateVO;
import iuap.portal.web.BaseController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/layoutTpl"})
public class LayoutTplController
extends BaseController {
    @Autowired
    private ILayoutTplService layoutTplService;

    @RequestMapping(path={"/loadAllTpl"}, method={RequestMethod.GET})
    @ResponseBody
    public Response list() {
        List<LayoutTemplateVO> layouts = this.layoutTplService.loadAllTpl();
        for (LayoutTemplateVO ew : layouts) {
            String tpl = null;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("class", "widgetBox connectedSortable");
            try {
                tpl = this.viewProcessService.adjustTpl(ew, "div", attrs);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                tpl = ew.getTpl();
            }
            ew.setTpl(tpl);
        }
        return this.success(null, layouts);
    }

    @RequestMapping(path={"/findAllTpl"}, method={RequestMethod.GET})
    @ResponseBody
    public Response findAllTpl() {
        List<LayoutTemplateVO> layouts = this.layoutTplService.findAllTpl();
        for (LayoutTemplateVO ew : layouts) {
            String tpl = null;
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("class", "widgetBox connectedSortable");
            try {
                tpl = this.viewProcessService.adjustTpl(ew, "div", attrs);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                tpl = ew.getTpl();
            }
            ew.setTpl(tpl);
        }
        return this.success(null, layouts);
    }

    @RequestMapping(path={"/getTplType"}, method={RequestMethod.GET})
    @ResponseBody
    public JSONObject getTplType() {
        JSONObject js = new JSONObject();
        try {
            Map<String, String> map = this.layoutTplService.getTplType();
            js.put("data", map);
            js.put("msg", (Object)"\u64cd\u4f5c\u6210\u529f");
            js.put("success", (Object)true);
            return js;
        }
        catch (Exception e) {
            e.printStackTrace();
            js.put("failure", (Object)false);
            return js;
        }
    }

    @RequestMapping(path={"/findCarouselByParam"}, method={RequestMethod.GET})
    @ResponseBody
    public Response findCarouselByParam(@RequestParam(value="searchText", required=false) String param, @RequestParam(value="carouselType", required=false) String type, @RequestParam(value="layoutId", required=false) String layoutId) {
        try {
            Cookie[] cooks = this.getRequest().getCookies();
            String companyId = null;
            Integer orgType = 1;
            for (int i = 0; i < cooks.length; ++i) {
                Cookie c = cooks[i];
                if (c.getName().equals("companyId")) {
                    companyId = c.getValue();
                }
                if (!c.getName().equals("orgType")) continue;
                orgType = Integer.parseInt(c.getValue());
            }
            WidgetVO[] widget = this.layoutTplService.findByParamAndType(param, type, companyId, orgType, layoutId);
            return this.success(null, widget);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.failure("");
        }
    }
}

