/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layoutx.controller;

import com.yyjz.icop.layoutx.entity.FuncOrgLayoutEntity;
import com.yyjz.icop.layoutx.service.LayoutXService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"layoutx"})
public class LayoutXController {
    @Autowired
    private LayoutXService layoutXService;

    @RequestMapping(value={"design/{funcLayoutId}"}, method={RequestMethod.POST})
    public Map<String, String> saveLayoutDesign(@PathVariable String funcLayoutId, @RequestBody String data) {
        this.layoutXService.saveLayoutDesign(funcLayoutId, data);
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("id", funcLayoutId);
        return r;
    }

    @RequestMapping(value={"design/{funcLayoutId}"}, method={RequestMethod.GET})
    public String getLayoutDesign(@PathVariable String funcLayoutId) {
        FuncOrgLayoutEntity entity = this.layoutXService.findById(funcLayoutId);
        if (entity != null) {
            return entity.getDesignDetail();
        }
        return "";
    }

    @RequestMapping(method={RequestMethod.POST})
    public Map<String, String> saveFunOrgLayout(@RequestBody FuncOrgLayoutEntity layoutEntity) {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("id", this.layoutXService.saveFunOrgLayout(layoutEntity));
        return r;
    }

    @RequestMapping(value={"{funcId}/{orgId}"}, method={RequestMethod.GET})
    public List<FuncOrgLayoutEntity> list(@PathVariable String funcId, @PathVariable String orgId) {
        List<FuncOrgLayoutEntity> entities = this.layoutXService.list(funcId, orgId);
        for (FuncOrgLayoutEntity entity : entities) {
            entity.setDesignDetail(null);
        }
        return entities;
    }

    @RequestMapping(value={"delete/{layoutId}"})
    public Map<String, String> delete(@PathVariable String layoutId) {
        this.layoutXService.delete(layoutId);
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("id", layoutId);
        return r;
    }
}

