/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layoutx.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yyjz.icop.layoutx.element.node.Cell;
import com.yyjz.icop.layoutx.element.node.Container;
import com.yyjz.icop.layoutx.element.node.Element;
import com.yyjz.icop.layoutx.element.node.WidgetBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public abstract class ElementParser {
    public static List<Element> parse(String json) {
        Assert.notNull((Object)json);
        JSONArray jsonArray = JSON.parseArray((String)json);
        return ElementParser.parse(jsonArray);
    }

    public static List<Element> parse(JSONArray jsonArray) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String tagName = jsonObject.getString("tag");
            Set keys = jsonObject.keySet();
            Element element = null;
            if ("Container".equals(tagName)) {
                element = new Container(tagName);
            }
            if ("ContainerCell".equals(tagName)) {
                element = new Cell(tagName);
            }
            if ("Widget".equals(tagName)) {
                element = new WidgetBox(tagName);
            }
            if (element == null) continue;
            elements.add(element);
            for (String key : keys) {
                if ("subElements".equals(key)) {
                    JSONArray subJSONArray = jsonObject.getJSONArray(key);
                    List<Element> subElements = ElementParser.parse(subJSONArray);
                    element.setSubElements(subElements);
                    continue;
                }
                element.attr(key, jsonObject.getString(key));
            }
        }
        return elements;
    }
}

