/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layoutx.element;

import com.yyjz.icop.layoutx.element.node.Element;
import com.yyjz.icop.layoutx.element.visitor.ElementVisitor;
import java.io.IOException;
import java.util.List;

public class ElementTraverser {
    public static void traverse(ElementVisitor visitor, Element root) {
        Element element = root;
        int dept = 0;
        try {
            while (element != null) {
                visitor.head(element);
                List<Element> subElements = element.getSubElements();
                if (subElements != null && subElements.size() > 0) {
                    Element parent = element;
                    element = subElements.get(0);
                    element.setParent(parent);
                    if (subElements.size() > 1) {
                        element.setSiblingIndex(1);
                    }
                    ++dept;
                    continue;
                }
                while (element.getSiblingIndex() == null && dept > 0) {
                    visitor.tail(element);
                    element = element.getParent();
                    --dept;
                }
                visitor.tail(element);
                if (element != root) {
                    if (element.getSiblingIndex() == null) continue;
                    Integer siblingIndex = element.getSiblingIndex();
                    Element parent = element.getParent();
                    element = parent.getSubElements().get(siblingIndex);
                    element.setParent(parent);
                    if (siblingIndex + 1 < parent.getSubElements().size()) {
                        element.setSiblingIndex(siblingIndex + 1);
                        continue;
                    }
                    element.setSiblingIndex(null);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

