/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layoutx.element.visitor;

import com.yyjz.icop.layoutx.element.node.Cell;
import com.yyjz.icop.layoutx.element.node.Container;
import com.yyjz.icop.layoutx.element.node.Element;
import com.yyjz.icop.layoutx.element.node.WidgetBox;
import com.yyjz.icop.layoutx.element.visitor.CellVisitor;
import com.yyjz.icop.layoutx.element.visitor.ContainerVisitor;
import com.yyjz.icop.layoutx.element.visitor.WidgetBoxVisitor;
import java.io.IOException;

public class ElementVisitor {
    private Appendable accumulation;
    private ContainerVisitor containerVisitor;
    private CellVisitor cellVisitor;
    private WidgetBoxVisitor widgetBoxVisitor;

    public ElementVisitor(Appendable accumulation) {
        this.accumulation = accumulation;
        this.containerVisitor = new ContainerVisitor();
        this.cellVisitor = new CellVisitor();
        this.widgetBoxVisitor = new WidgetBoxVisitor();
    }

    public void head(Element element) throws IOException {
        if (element instanceof Container) {
            this.containerVisitor.head((Container)element, this.accumulation);
        }
        if (element instanceof Cell) {
            this.cellVisitor.head((Cell)element, this.accumulation);
        }
        if (element instanceof WidgetBox) {
            this.widgetBoxVisitor.head((WidgetBox)element, this.accumulation);
        }
    }

    public void tail(Element element) throws IOException {
        if (element instanceof Container) {
            this.containerVisitor.tail((Container)element, this.accumulation);
        }
        if (element instanceof Cell) {
            this.cellVisitor.tail((Cell)element, this.accumulation);
        }
        if (element instanceof WidgetBox) {
            this.widgetBoxVisitor.tail((WidgetBox)element, this.accumulation);
        }
    }
}

