/*
 * Decompiled with CFR 0.152.
 */
package com.yyjz.icop.layoutx.service.impl;

import com.yonyou.iuap.context.InvocationInfoProxy;
import com.yyjz.icop.layoutx.element.ElementParser;
import com.yyjz.icop.layoutx.element.node.Element;
import com.yyjz.icop.layoutx.entity.FuncOrgLayoutEntity;
import com.yyjz.icop.layoutx.repository.FuncOrgLayoutDao;
import com.yyjz.icop.layoutx.service.LayoutXService;
import iuap.portal.entity.LayoutVO;
import iuap.portal.util.UUIDUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LayoutXServiceImpl
implements LayoutXService {
    @Autowired
    private FuncOrgLayoutDao funcOrgLayoutDao;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public void saveLayoutDesign(String funcLayoutId, String json) {
        FuncOrgLayoutEntity funcOrgLayoutEntity = (FuncOrgLayoutEntity)((Object)this.funcOrgLayoutDao.getOne((Serializable)((Object)funcLayoutId)));
        if (funcOrgLayoutEntity == null) {
            throw new RuntimeException("\u6ca1\u6709\u5e03\u5c40\u4fe1\u606f");
        }
        String ptLayoutId = funcOrgLayoutEntity.getPtLayoutId();
        List<Element> elements = ElementParser.parse(json);
        StringBuilder accumulation = new StringBuilder();
        for (int i = 0; i < elements.size(); ++i) {
            accumulation.append(elements.get(i).html());
        }
        if (StringUtils.isBlank((CharSequence)ptLayoutId)) {
            LayoutVO layoutVO = new LayoutVO();
            layoutVO.setTemplateid("design");
            layoutVO.setPkLayout(UUIDUtils.uuid().replace("-", ""));
            layoutVO.setId(UUIDUtils.uuid().replace("-", ""));
            layoutVO.setSetting(accumulation.toString());
            layoutVO.setRnd(UUIDUtils.base58Uuid());
            StringBuilder insetPTLayoutSQL = new StringBuilder();
            insetPTLayoutSQL.append(" INSERT INTO pt_layout ( templateid, setting, pk_layout, id, ctime, tenant, isenable, rnd, ts, dr, tenant_id, name ) ").append(" VALUES (").append(" ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?").append(" )");
            this.jdbcTemplate.update(insetPTLayoutSQL.toString(), new Object[]{layoutVO.getTemplateid(), layoutVO.getSetting(), layoutVO.getPkLayout(), layoutVO.getId(), new Date(), InvocationInfoProxy.getTenantid(), "Y", layoutVO.getRnd(), new Date(), 0, InvocationInfoProxy.getTenantid(), funcOrgLayoutEntity.getName()});
            funcOrgLayoutEntity.setPtLayoutId(layoutVO.getPkLayout());
            funcOrgLayoutEntity.setDesignDetail(json);
        } else {
            StringBuilder updatePtLayoutSQL = new StringBuilder();
            updatePtLayoutSQL.append(" UPDATE pt_layout  ").append(" SET setting = ?, ").append(" ts = ?, ").append(" modifytime = ?, ").append(" rnd = ?  ").append(" WHERE ").append(" \tpk_layout = ? ");
            this.jdbcTemplate.update(updatePtLayoutSQL.toString(), new Object[]{accumulation.toString(), new Date(), new Date(), UUIDUtils.base58Uuid(), ptLayoutId});
            funcOrgLayoutEntity.setDesignDetail(json);
        }
    }

    @Override
    public String saveFunOrgLayout(FuncOrgLayoutEntity entity) {
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        entity.setTs(new Date());
        FuncOrgLayoutEntity save = (FuncOrgLayoutEntity)((Object)this.funcOrgLayoutDao.save((Object)entity));
        return save.getId();
    }

    @Override
    public List<FuncOrgLayoutEntity> list(String funcId, String orgId) {
        return this.funcOrgLayoutDao.queryByOrgId(funcId, orgId, InvocationInfoProxy.getTenantid());
    }

    @Override
    public void delete(String id) {
        this.funcOrgLayoutDao.delete((Serializable)((Object)id));
    }

    @Override
    public FuncOrgLayoutEntity findById(String funcOrgLayoutId) {
        return (FuncOrgLayoutEntity)((Object)this.funcOrgLayoutDao.getOne((Serializable)((Object)funcOrgLayoutId)));
    }
}

